(function() {
    var BIDS_CORRECTION_WARNINGS = {
        geo_multiplier: iget2('i-utils', 'bids-correction-warning-geo', 'по региону показа'),
        retargeting_multiplier: iget2('i-utils', 'bids-correction-warning-retargeting', 'по условиям ретаргетинга'),
        demography_multiplier: iget2('i-utils', 'bids-correction-warning-demography', 'по полу и возрасту'),
        performance_tgo_multiplier: iget2('i-utils', 'bids-correction-warning-performance-tgo1', 'на смарт-объявления'),
        mobile_multiplier: iget2('i-utils', 'bids-correction-warning-mobile', 'на мобильные'),
        devices_multiplier: iget2('i-utils', 'bids-correction-warning-devices', 'на устройства'),
        ab_segment_multiplier: iget2('i-utils','bids-correction-warning-ab-segments', 'по сегментам'),
        video_multiplier: iget2('i-utils', 'bids-correction-warning-video', 'на видео'),
        timetargeting_multiplier: iget2('i-utils', 'bids-correction-warning-timetargeting', 'по временному таргетингу'),
        cpm_group_type_multiplier: iget2('i-utils', 'bids-correction-warning-inventory', 'по типу инвентаря')
    };

    function getBidsCorrectionKeys(multipliers, isDevicesEnabled) {
        var keys = [];

        if (!multipliers) return keys;

        function checkIsEnabled(key) {
            multipliers[key] && Number(multipliers[key].is_enabled) === 1 && keys.push(key);
        }

        function checkBidSegments(key) {
            multipliers[key] &&
            Number(multipliers[key].is_enabled) === 1 &&
            multipliers[key].ab_segments && u._.isArray(multipliers[key].ab_segments) &&
            (multipliers[key].ab_segments.length > 0) &&
            keys.push(key);
        }

        function checkKey(key) {
            multipliers[key] && keys.push(key);
        }

        checkIsEnabled('geo_multiplier');
        checkIsEnabled('retargeting_multiplier');
        checkIsEnabled('demography_multiplier');

        checkBidSegments('ab_segment_multiplier');

        checkKey('performance_tgo_multiplier');

        if (isDevicesEnabled) {
            if (multipliers.mobile_multiplier || multipliers.desktop_multiplier) {
                keys.push('devices_multiplier');
            }
        } else {
            checkKey('mobile_multiplier');
        }

        checkKey('video_multiplier');

        if (multipliers['banner_type_multiplier'] || multipliers['inventory_multiplier'] || multipliers['weather_multiplier']) {
            keys.push('cpm_group_type_multiplier');
        }

        return keys;
    }

    u.register({
        bids: {
            /**
             * Возвращает ограничения для значений ставок и текст ошибки при нарушении данных ограничений
             * @param {'all'|'m-campaign'|'dm-mobile-content-campaign'|'dm-dynamic-media-campaign'|'dm-cpm-banner-campaign'} campaignModelName
             * название модели кампании (all если ставка общая на несколько типов кампаний)
             * @param {String} currencyName код валюты (например, RUB)
             * @param {String} [cid] - id кампании
             * @param {String} [adgroup_id] - id группы
             */
            getLimits: function(campaignModelName, currencyName, cid, adgroup_id) {
                var currencyConsts = u.currencies.get(currencyName),
                    isCpmBannerCampaign = [
                        'dm-cpm-banner-campaign', 'dm-cpm-deals-campaign', 'dm-cpm-yndx-frontpage-campaign'
                    ].indexOf(campaignModelName) !== -1,
                    minPriceConstName = isCpmBannerCampaign ? 'MIN_CPM_PRICE' : 'MIN_PRICE',
                    maxPriceConstName = isCpmBannerCampaign ? 'MAX_CPM_PRICE' : 'MAX_PRICE',
                    priceLimits;

                priceLimits = {
                    minPrice: {
                        value: Number(currencyConsts[minPriceConstName]),
                        errorText: iget2('i-utils', 'stavka-dolzhna-byt-ne', 'Ставка должна быть не меньше {value}', {
                            value: u.currencies.formatConst(currencyName, minPriceConstName),
                            context: 'value - 1 руб.'
                        })
                    },
                    maxPrice: {
                        value: Number(currencyConsts[maxPriceConstName]),
                        errorText: iget2('i-utils', 'stavka-dolzhna-byt-ne-100', 'Ставка должна быть не больше {value}', {
                            value: u.currencies.formatConst(currencyName, maxPriceConstName),
                            context: 'value - 1 руб.'
                        })
                    }
                };

                // Для "медийного продукта на главной" за ставками ходим в cpm-yndx-frontpage-min-price
                if (campaignModelName === 'dm-cpm-yndx-frontpage-campaign' &&
                    u._.get(BEM, ['blocks', 'cpm-yndx-frontpage-min-price'])) {
                    var cpmYndxFrontpageMinPrice = BEM.blocks['cpm-yndx-frontpage-min-price'].getMinPrice(
                        u._.compact([cid, adgroup_id]),
                        currencyName
                    );

                    priceLimits.minPrice = {
                        value: Number(cpmYndxFrontpageMinPrice),
                        errorText: iget2('i-utils', 'stavka-dolzhna-byt-ne', 'Ставка должна быть не меньше {value}', {
                            value: u.currencies.formatSum(currencyName, cpmYndxFrontpageMinPrice),
                            context: 'value - 1 руб.'
                        })
                    };
                }

                // для охватного продукта не делаем предупреждения про слишком высокую ставку,
                // так как нет общего понимания, какая ставка большая для клиента, все зависит от тематики
                if (!isCpmBannerCampaign) {
                    priceLimits.bigRate = {
                        value: Number(currencyConsts['BIG_RATE']),
                        errorText: iget2(
                            'i-utils',
                            'high-bid-warning',
                            'Обратите внимание, установлена высокая ставка'
                        )
                    };
                }

                return priceLimits;
            },

            /**
             * Формирует список предупреждений о корректировках
             * @param {Object} campaign - кампания
             * @param {Number} campaign.timetarget_coef - корректировка по врвменному таргетингу
             * @param {Object[]} campaign.groups - список групп кампании
             * @param {Object} hierarchicalMultipliers - корректировки на уровне кампании
             * @param {Boolean} isDevicesEnabled - Разрешены ли корректировки на устройства
             * @returns {String[]}
             */
            getBidsCorrectionWarning: function(campaign, hierarchicalMultipliers, isDevicesEnabled) {
                var lines = [],
                    keys = !campaign.strategy.is_autobudget && campaign.timetarget_coef !== 100 ? ['timetargeting_multiplier'] : [];

                keys = keys.concat(getBidsCorrectionKeys(hierarchicalMultipliers, isDevicesEnabled));

                if (keys.length) {

                    // корректировки на уровне кампании
                    lines.push(iget2('i-utils', 'bids-correctino-warning-for-campaign', 'Установлены корректировки ставок на кампанию: {list}.', {
                        list: keys.map(function(key) {
                            return BIDS_CORRECTION_WARNINGS[key];
                        }).filter(Boolean).join(', ')
                    }));
                }

                // корректировки на уровне групп
                campaign.groups.some(function(group) {
                    return !!getBidsCorrectionKeys(group.group_hierarchical_multipliers, isDevicesEnabled).length;
                }) && lines.push(iget2('i-utils', 'bids-correction-warning-for-groups', 'Установлены корректировки ставок в некоторых группах.'));

                return lines;
            }
        }
    });

})();
