(function() {
    function getRequest(ctx) {

        return _request || (_request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            cache: false,
            type: 'POST',
            callbackCtx: ctx
        }));
    }

    function getCampOptions() {
        var campOpt = '{}';

        // В camp_options может прийти undefined и тогда мы упадем :(
        if (u.consts('camp_options') && u.consts('camp_options') !== 'undefined') {
            campOpt = u.consts('camp_options');
        }

        return _campOptions || (_campOptions || JSON.parse(campOpt));
    }

    function getCampCid() {
        return _cid || (_cid = +JSON.parse(u.consts('camp_options_cid')));
    }

    var _request,
        _cid,
        _campOptions,
        campOptions = {
            /**
             * Отправляет запрос ajaxCampOptions с заданными параметрами
             * @param {Object} params
             * @param {String} params.cid - id кампании
             * @param {Function} callback
             * @param {Object} ctx - контекст выполнения колбэка
             */
            request: function(params, callback, ctx) {
                getRequest(this).get($.extend(params, { cmd: 'ajaxCampOptions' }), function(data) {
                    callback = callback || function() {};

                    callback.call(ctx, data);

                });
            },

            /**
             * Записывает значение value в поле name в CAMP_OPTIONS
             * @param {String} name - имя поля
             * @param {*} value значение поля
             * @param {Function} [callback]
             * @param {Object} [ctx]
             */
            set: function(name, value, callback, ctx) {
                var campOptions = getCampOptions(),
                    saveData = { cmd: 'ajaxCampOptions', cid: getCampCid() };

                campOptions[name] = saveData[name] = value;

                callback = callback || function() {};

                getRequest(ctx).get(saveData, callback);
            },

            /**
             * Записывает данные в CAMP_OPTIONS
             * @param {Object} data - объект с данными, которые надо сохранить
             * @param {Function} [callback]
             * @param {Object} [ctx]
             */
            update: function(data, callback, ctx) {
                var campOptions = getCampOptions(),
                    saveData = { cmd: 'ajaxCampOptions', cid: getCampCid() };

                Object.keys(data).forEach(function(key) {
                    campOptions[key] = saveData[key] = data[key];
                });

                callback = callback || function() {};

                getRequest(ctx).get(saveData, callback);
            },

            /**
             * Удаляет поле name из CAMP_OPTIONS
             * @param {String} name
             * @param {Function} [callback]
             * @param {Object} [ctx]
             */
            remove: function(name, callback, ctx) {
                getCampOptions()[name] = null;

                callback = callback || function() {};

                getRequest(ctx).get({ cmd: 'ajaxCampOptions', cid: getCampCid(), delete: name }, callback);
            },

            get: function(name) {
                var result = getCampOptions()[name];

                if (name == 'price_editor' ) { //DIRECT-30791
                    try {
                        result = JSON.parse(result);
                        delete result.current_camp_cid;
                        result = JSON.stringify(result);
                    } catch (e) {}
                }

                return result;
            }
        };

    u.register({
        campOptions: campOptions
    });

})();
