(function() {
    var typeToAddGroupCmd = {
            dynamic: 'addDynamicAdGroups',
            mobile_content: 'addAdGroupsMobileContent',
            performance: 'addAdGroupsPerformance',
            mcbanner: 'addMediaAdGroups',
            cpm_banner: 'addAdGroupsCpmBanner',
            cpm_deals: 'addAdGroupsCpmBanner',
            cpm_yndx_frontpage: 'addAdGroupsCpmBanner',
            content_promotion: 'addAdGroupsContentPromotion'
        },
        typeToEditGroupCmd = {
            dynamic: 'editDynamicAdGroups',
            mobile_content: 'editAdGroupsMobileContent',
            text: 'showCampMultiEdit',
            performance: 'editAdGroupsPerformance',
            mcbanner: 'editMediaAdGroups',
            cpm_banner: 'editAdGroupsCpmBanner',
            cpm_deals: 'editAdGroupsCpmBanner',
            cpm_yndx_frontpage: 'editAdGroupsCpmBanner',
            content_promotion: 'editAdGroupsContentPromotion'
        },
        modelNames = {
            dynamic: {
                campaign: 'm-campaign',
                group: 'dm-dynamic-group',
                banner: 'dm-dynamic-banner'
            },
            performance: {
                campaign: 'dm-dynamic-media-campaign',
                group: 'dm-dynamic-media-group',
                banner: 'dm-dynamic-media-banner'
            },
            mobile_content: {
                campaign: 'dm-mobile-content-campaign',
                group: 'dm-mobile-content-group',
                banner: 'dm-mobile-content-banner'
            },
            mcbanner: {
                campaign: 'm-campaign',
                group: 'dm-mcbanner-group',
                banner: 'm-banner'
            },
            cpm_banner: {
                campaign: 'dm-cpm-banner-campaign',
                group: 'dm-cpm-banner-group',
                banner: 'dm-cpm-banner'
            },
            cpm_deals: {
                campaign: 'dm-cpm-deals-campaign',
                group: 'dm-cpm-deals-group',
                banner: 'dm-cpm-deals-banner'
            },
            text: {
                campaign: 'm-campaign',
                group: 'm-group',
                banner: 'm-banner'
            },
            mcb: {
                campaign: 'm-campaign',
                group: 'm-group',
                banner: 'm-banner'
            },
            cpm_yndx_frontpage: {
                campaign: 'dm-cpm-yndx-frontpage-campaign',
                group: 'dm-cpm-yndx-frontpage-banner-group',
                banner: 'dm-cpm-yndx-frontpage-banner'
            },
            content_promotion: {
                campaign: 'm-campaign',
                group: 'dm-content-promotion-group',
                banner: 'dm-content-promotion-banner'
            },
            // легаси media_type, когда делали видео-продвижение
            content_promotion_video: {
                campaign: 'm-campaign',
                group: 'dm-content-promotion-group',
                banner: 'dm-content-promotion-banner'
            },
            internal_distrib: {
                campaign: 'dm-internal-distrib-campaign'
            },
            internal_free: {
                campaign: 'dm-internal-free-campaign'
            },
            cpm_price: {
                campaign: 'dm-cpm-price-campaign',
                group: 'dm-cpm-price-banner-group',
                banner: 'dm-cpm-price-banner'
            },
        },
        cpmTypes = ['cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage', 'cpm_price'];

    u.register({
        campaign: {
            /**
             * Возвращает название контроллера добавления группы по типу кампании
             * @param {String} type
             * @returns {String}
             * @throws {String}
             */
            getAddCmdByMediaType: function(type) {
                return typeToAddGroupCmd[type] || 'addBannerMultiEdit';
            },

            /**
             * Возвращает название контроллера добавления группы по типу кампании
             * @param {String} type
             * @returns {String}
             * @throws {String}
             */
            getEditCmdByMediaType: function(type) {
                return typeToEditGroupCmd[type] || 'showCampMultiEdit';
            },

            /**
             * Получаем имя модели кампании в зависимости от mediaType
             * @param {String} mediaType
             * @returns {String}
             */
            getCampaignModelName: function(mediaType) {
                return modelNames[mediaType].campaign;
            },

            /**
             * Получаем имя модели группы в зависимости от mediaType
             * @param {String} mediaType
             * @returns {String}
             */
            getGroupModelName: function(mediaType) {
                return modelNames[mediaType].group;
            },

            /**
             * Получаем имя модели баннера в зависимости от mediaType
             * @param {String} mediaType
             * @returns {String}
             */
            getBannerModelName: function(mediaType) {
                mediaType = mediaType || 'text';

                return modelNames[mediaType].banner;
            },

            /**
             * Возвращает cmd для аяксового сохранения фильтров по фидам
             * @param {String} type
             * @returns {string}
             */
            getSaveFilterAjaxCmd: function(type) {
                return type == 'dynamic' ? 'ajaxEditDynamicConditions' : 'ajaxEditPerformanceFilters';
            },

            /**
             * Возвращает название основного поля для аяксового сохранения фильтров по фидам
             * @param {String} type
             * @returns {string}
             */
            getSaveFilterAjaxParamName: function(type) {
                return type == 'dynamic' ? 'json_adgroup_dynamic_conditions' : 'json_adgroup_performance_filters';
            },

            /**
             * Возвращает ссылку на хэлп для блока добавления фильтров по фиду в зависимости от типа кампании
             * @param {String} type
             * @returns {String}
             */
            getAddFilterHelpUrl: function(type) {
                return type == 'dynamic' ? 'dynamic-text-ads-feed-filters' : 'smart-banners-feed-filters';
            },

            /**
             * Возвращает название страницы phrase-detail в статистике в зависимости от типа кампании
             * @param {String} mediaType
             * @returns {String}
             */
            getPhraseDetailStatTitle: function(mediaType) {
                switch (mediaType) {
                    case 'performance':
                        return iget2('i-utils', 'usloviya-pokaza-po-dnyam', 'Условия показа по дням');
                    case 'dynamic':
                        return iget2('i-utils', 'usloviya-pokaza-po-dnyam', 'Условия показа по дням');
                    case 'cpm_banner':
                    case 'cpm_deals':
                    case 'cpm_yndx_frontpage':
                        return iget2('i-utils', 'usloviya-pokaza-po-dnyam', 'Условия показа по дням');
                    default:
                        return iget2('i-utils', 'frazy-po-dnyam', 'Фразы по дням');
                }
            },

            /**
             * Возвращает модификатор контролла для ввода цены у фильтра по фиду
             * @param {String} mediaType
             * @param {Object} strategy
             * @returns {String}
             */
            getFilterPricesControlsMod: function(mediaType, strategy) {
                var strategyMod;

                if (mediaType == 'dynamic') {
                    if (strategy.name == 'different_places') {
                        strategyMod = strategy.is_autobudget ?
                            'default' :
                            strategy.is_search_stop ?
                                'net' :
                                 'different-places'
                    } else {
                        strategyMod = strategy.is_autobudget ? 'default' : 'search';
                    }
                } else if (mediaType == 'performance') {
                    strategyMod = {
                        autobudget_avg_cpc_per_camp: 'avg-cpc',
                        autobudget_avg_cpc_per_filter: 'avg-cpc',
                        autobudget_avg_cpa_per_camp: 'avg-cpa',
                        autobudget_avg_cpa_per_filter: 'avg-cpa'
                    }[strategy.name] || 'default';
                }

                return strategyMod;
            },

            /**
             * Возвращает список с типом контроллов (модификаторы для  b-edit-phrase-price) ввода цены у фильтра по фиду
             * @param {String} mediaType
             * @param {Object} strategy
             * @returns {String[]}
             */
            getFilterPricesControlsNames: function(mediaType, strategy) {
                if (mediaType === 'performance') {
                    return strategy.name.match('_cpa_') ? ['cpa'] : ['cpc']
                } else if (mediaType == 'dynamic') {
                    if (strategy.is_autobudget) {
                        return ['autobudget']
                    } else {
                        if (strategy.name == 'different_places') {
                            return strategy.is_search_stop ? ['context'] : ['search', 'context']
                        } else {
                            return ['search'];
                        }
                    }
                }

            },

            /**
             * Возвращает заголовок первой колонки на странице статистики Фразы/Условия показа по дням
             * @param {String} mediaType
             * @returns {String}
             */
            getPhraseDetailStatFirstColTitle: function(mediaType) {
                switch (mediaType) {
                    case 'performance':
                        return iget2('i-utils', 'filtr', 'Фильтр');
                    case 'dynamic':
                        return iget2('i-utils', 'uslovie-pokaza', 'Условие показа');
                    case 'cpm_banner':
                    case 'cpm_deals':
                    case 'cpm_yndx_frontpage':
                        return iget2('i-utils', 'uslovie-pokaza', 'Условие показа');
                    default:
                        return iget2('i-utils', 'fraza-maksimalnaya-stavka', 'Фраза / максимальная ставка');
                }
            },

            /**
             * Проверяет есть ли хотя бы одна кампания с типом из перечня types
             * @param {Array<{ type: string }> | undefined} campaigns
             * @param {string[]} types
             * @return {boolean}
             */
            hasCampByTypes: function(campaigns, types) {
                if (!Array.isArray(campaigns)) {
                    return false;
                }

                return campaigns.some(function(camp) {
                    return types.indexOf(camp.type) !== -1;
                });
            },

            cpmTypes: cpmTypes.slice(),

            /**
             * Проверяет является ли кампаний с переданным mediaType медийной
             * @param {string} mediaType
             * @returns {boolean}
             */
            isCpm: function(mediaType) {
                return cpmTypes.slice().indexOf(mediaType) !== -1;
            },

            /**
             * Проверяет является ли кампаний с переданным mediaType внутренней (Банана-кампанией)
             * @param {string} mediaType
             * @returns {boolean}
             */
            isInternal: function(mediaType) {
                return ['internal_distrib', 'internal_free', 'internal_autobudget'].indexOf(mediaType) !== -1;
            },

            /**
             * Проверяет является ли кампаний с переданным mediaType внутренней (Банана-кампанией)
             * @param {string[]} [mediaTypes]
             * @returns {boolean}
             */
            hasInternal: function(mediaTypes) {
                if (!Array.isArray(mediaTypes) || mediaTypes.length === 0) {
                    return false;
                }

                return mediaTypes.some(function(campType) {
                    return u.campaign.isInternal(campType);
                });
            },

            /**
             * Доступные условия показа для каждной из группы медийной кампании
             */
            getCpmGroupDisplayConditions: function(cpmGroupType) {
                return {
                    cpm_video: ['crypta'],
                    cpm_audio: ['crypta'],
                    cpm_banner: ['crypta', 'keywords'],
                    cpm_yndx_frontpage: ['crypta'],
                    cpm_geoproduct: ['crypta'],
                    cpm_outdoor: ['crypta'],
                    cpm_indoor: ['crypta']
                }[cpmGroupType];
            },

            /**
             * Доступные креативы для каждной из группы медийной кампании
             */
            getCpmGroupCreatives: function(cpmGroupType) {
                return {
                    cpm_video: ['video_addition'],
                    cpm_audio: ['audio_addition'],
                    cpm_banner: ['canvas', 'html5_creative'],
                    cpm_yndx_frontpage: ['canvas', 'html5_creative'],
                    cpm_outdoor: ['canvas'],
                    cpm_indoor: ['video_addition']
                }[cpmGroupType];
            },

            /**
             * Маппинг версии морды в формат прогнозатора
             * для browser_new_tab (нтп) заведено два пейджа (яндекс.браузер и яндексовый экстеншен), и под каждый свой тег
             * @param {String} type
             * @returns {String}
             */
            frontpageTypeToForecastFormat: function(type) {
                return {
                    frontpage: 'portal-home-desktop',
                    frontpage_mobile: 'portal-home-mobile',
                    browser_new_tab: ['portal-home-ntp', 'portal-home-ntp-chrome']
                }[type];
            }

        }
    });

}());
