(function(ctx) {
    var hasProp = {}.hasOwnProperty;

    u.register({

        consts: function(name) {
            var isClient = !!(BEM.blocks && BEM.blocks['i-global']),
                pageConsts = isClient ? window.PAGECONSTS : null,
                mainConsts = isClient ? window.CONSTS : ctx.data.CONSTS;

            // на клиенте смотрим сначала в PAGECONSTS
            if (pageConsts && hasProp.call(pageConsts, name)) return pageConsts[name];

            // затем и на клиенте и на сервере смотрим в CONSTS
            if (mainConsts && hasProp.call(mainConsts, name)) return mainConsts[name];

            // потом на клиенте спрашиваем у i-global
            if (isClient) return BEM.blocks['i-global'].param(name);

            // а на сервере лезем i-global'у внутрь
            // учитываем, что в моде preprocess ещё нет this['i-global']
            return (ctx['i-global'] || {})[name];
        }

    });

})(this);
