describe('i-utils__context-limit', function() {
    describe('prepareValue', function() {
        var dataSets = [
            [undefined, 100],
            [null, 100],
            ['100', 100],
            ['255', 100],
            ['254', 100], //@see https://st.yandex-team.ru/DIRECT-59829#1477487388000
            ['10', 10],
            ['90', 90],
            ['0', 0]
        ];

        dataSets.forEach(function(data) {
            it('Значение ' + data[0] + ' должно перевестись в ' + data[1], function() {
                expect(u.contextLimit.prepareValue(data[0])).to.be.equal(data[1]);
            });
        });
    });

    describe('isContextShowNotLimited', function() {
        [[100, true], ['100', true], ['10', false], [10, false], [0, false]].forEach(function(data) {
            it('isContextShowNotLimited на значении ' + data[0] + ' должно возвращать ' + data[1], function() {
                expect(u.contextLimit.isContextShowNotLimited(data[0])).to.be.equal(data[1]);
            });
        });
    });

    describe('isFieldDisabled', function() {
        [
            { name: 'ContextLimit', isDiffPlace: true, isNetStopped: true, result: true },
            { name: 'ContextLimit', isDiffPlace: true, isNetStopped: false, result: true },
            { name: 'ContextLimit', isDiffPlace: false, isNetStopped: true, result: false },
            { name: 'ContextLimit', isDiffPlace: false, isNetStopped: false, result: false },

            { name: 'ContextPriceCoef', isDiffPlace: true, isNetStopped: true, result: true },
            { name: 'ContextPriceCoef', isDiffPlace: true, isNetStopped: false, result: true },
            { name: 'ContextPriceCoef', isDiffPlace: false, isNetStopped: true, result: true },
            { name: 'ContextPriceCoef', isDiffPlace: false, isNetStopped: false, result: false },

            { name: 'enable_cpc_hold', isDiffPlace: true, isNetStopped: true, result: true },
            { name: 'enable_cpc_hold', isDiffPlace:true, isNetStopped: false, result: true },
            { name: 'enable_cpc_hold', isDiffPlace: false, isNetStopped: true, result: true },
            { name: 'enable_cpc_hold', isDiffPlace: false, isNetStopped: false, result: false },
        ].forEach(function(data) {
            it('Поле ' + data.name + ' c стратегией ' + (data.isDiffPlaces  ? ' ' : ' не ') + 'отдельное размещение и ' + (data.isNetStopped  ? '' : ' не ') + 'остановленными показами на сетях' + (data.result ? ' ' : ' не ') + 'должно быть неактивно', function() {
                expect(u.contextLimit.isFieldDisabled(data.name, data.isDiffPlace, data.isNetStopped)).to.equal(data.result);
            });
        });
    });

    describe('getText', function() {
        var sandbox;

        beforeEach(function() {
            sandbox = sinon.sandbox.create();
        });

        afterEach(function() {
            sandbox.restore();
        });

        [
            {
                params: {
                    ContextLimit: 0,
                    ContextPriceCoef: 100,
                    isDiffPlaces: false,
                    enable_cpc_hold: 1,
                    areStrategyDependableShows: false
                },
                result: ['standartnye']
            },
            {
                params: {
                    ContextLimit: 10,
                    ContextPriceCoef: 10,
                    isDiffPlaces: false,
                    enable_cpc_hold: 1,
                    areStrategyDependableShows: false
                },
                result: [
                    'rashod-v-setyah-uderzhivat',
                    'stavka-nbsp',
                    'uderzhivat-srednyuyu-stavku-klika'
                ]
            },
            {
                params: {
                    ContextLimit: 100,
                    ContextPriceCoef: 10,
                    isDiffPlaces: false,
                    areStrategyDependableShows: false
                },
                result: [
                    'rashod-v-setyah-ne',
                    'stavka-nbsp'
                ]
            },
            {
                params: {
                    ContextLimit: 100,
                    ContextPriceCoef: 10,
                    isDiffPlaces: true,
                    enable_cpc_hold: 1,
                    areStrategyDependableShows: true
                },
                result: ['pokazy-idut-v-sootvetstvii']
            }
        ].forEach(function(data) {
            it('С настройками ' + JSON.stringify(data.params) + ' должен возвращаться результат ' + data.result.join(','), function() {

                var igetStub = sandbox.stub(window, 'iget2');

                data.result.forEach(function(key) {
                    igetStub.withArgs('i-utils', key).returns(key);
                });

                expect(u.contextLimit.getText(data.params, false).join(',')).to.equal(data.result.join(','));
            });
        });
    });
});
