u.register({
    contextLimit: {
        /**
         * Переводит значение из формата пришедшего с сервера, в формат, понимаемый клиентом
         * @param {Number} value
         * @returns {Number}
         */
        prepareValue: function(value) {
            if (value === undefined || value === null) return 100;

            value = +value;

            if (value == 255 || value == 254) return 100;

            return value;
        },

        /**
         * Расход на тематических площадках не ограничен
         * @param {Number} value
         * @returns {boolean}
         */
        isContextShowNotLimited: function(value) {
            return this.prepareValue(value) === 100;
        },

        /**
         *
         * @param {String} name имя поля
         * @param {Boolean} isDiffPlaces  выбрана стратегия отдельное размещение
         * @param {Boolean} isNetStopped отключены ли показы в сетях
         * @returns {Boolean}
         */
        isFieldDisabled: function(name, isDiffPlaces, isNetStopped) {
            switch (name) {
                case 'ContextLimit':
                    return !!isDiffPlaces;
                case 'ContextPriceCoef':
                    return isDiffPlaces || isNetStopped;
                case 'enable_cpc_hold':
                    return isDiffPlaces || isNetStopped;
            }

            return false;
        },

        /**
         * Формирует текст для ограничений на тематических площадках
         * @param {Object} params
         * @param {String} params.isDiffPlaces
         * @param {String} params.strategyName
         * @param {String} params.ContextLimit
         * @param {String} params.ContextPriceCoef
         * @param {String} params.enable_cpc_hold
         * @param {Boolean} isNetStopped отключены ли показы на сетях
         * @returns {Array}
         */
        getText: function(params, isNetStopped) {
            var limit = params.ContextLimit,
                pCoef = params.ContextPriceCoef,
                isDiffPlaces = params.isDiffPlaces,
                enable_cpc_hold = params.enable_cpc_hold,
                contextLimitDisabled = u.contextLimit.isFieldDisabled('ContextLimit', isDiffPlaces, isNetStopped),
                defaultValues = this.getDefaultValues(),
                result = [];

            if (isNetStopped) {
                result.push(iget2('i-utils', 'pokazy-zapreshcheny', 'Показы запрещены'));
            } else if (params.areStrategyDependableShows) {
                result.push(iget2('i-utils', 'pokazy-idut-v-sootvetstvii', 'Показы идут в соответствии с настройками стратегии'));
            } else if (['ContextLimit', 'ContextPriceCoef', 'enable_cpc_hold'].every(function(name) {
                //@heliarian не используем isEqual для объекта, т.к. может быть нестрогое равенство
                return params[name] == defaultValues[name] &&
                    !u.contextLimit.isFieldDisabled(name, isDiffPlaces, isNetStopped);
            })) {
                result.push(iget2('i-utils', 'standartnye', 'Стандартные'));
            } else {

                if (!contextLimitDisabled && u.contextLimit.isContextShowNotLimited(limit)) {
                    result.push(iget2('i-utils', 'rashod-v-setyah-ne', 'Расход в сетях не&nbsp;ограничен'));
                } else if (!contextLimitDisabled) {
                    result.push(iget2(
                        'i-utils',
                        'rashod-v-setyah-uderzhivat',
                        'Расход в сетях удерживать в&nbsp;пределах {foo}% от&nbsp;общего расхода кампании',
                        {
                            foo: u.escapeHTML(limit)
                        }
                    ));
                }

                !u.contextLimit.isFieldDisabled('ContextPriceCoef', isDiffPlaces, isNetStopped) &&
                    result.push(iget2(
                        'i-utils',
                        'stavka-nbsp',
                        'Ставка&nbsp;&mdash;&nbsp;{foo}% от&nbsp;назначенной ставки на&nbsp;поиске',
                        {
                            foo: u.escapeHTML(pCoef || 100)
                        }
                    ));

                !u.contextLimit.isFieldDisabled('enable_cpc_hold', isDiffPlaces, isNetStopped) &&
                    enable_cpc_hold == 1 &&
                    result.push(iget2('i-utils', 'uderzhivat-srednyuyu-stavku-klika', 'Удерживать среднюю ставку ниже средней ставки на поиске'));
            }

            return result;
        },

        /**
         * Определяет идут ли показы в сетях в соответсвии с настройками стратегии
         * @param {String} strategyName
         * @param {Object} strategyOptions
         * @returns {boolean}
         */
        areStrategyDependableShows: function(strategyName, strategyOptions) {
            return [
                u.strategy.DIFFERENT_PLACES,
                u.strategy.AUTOBUDGET_ROI,
                u.strategy.AUTOBUDGET_AVG_CPA,
                u.strategy.AUTOBUDGET_AVG_CPI
            ].includes(strategyName) ||
                // стратегия Недельный бюджет с максимальной конферсией по целям
                strategyName === u.strategy.AUTOBUDGET && strategyOptions.goal_id !== '' && strategyOptions.goal_id !== null;
        },

        /**
         * Возвращает хэш с дефолтными настройками сетей
         * @returns {{ContextLimit: number, ContextPriceCoef: number, enable_cpc_hold: number}}
         * @private
         */
        getDefaultValues: function() {
            return {
                ContextLimit: 0,
                ContextPriceCoef: 100,
                enable_cpc_hold: 1
            };
        },

        /**
         * Является ли стратегия той при которой показываем
         * и принимаем в расчет параметр enable_cpc_hold
         *
         * Параметр не участвует в расчетах для стратегий:
         * Независимое управление для разных типов площадок
         * Средняя цена клика
         * Средняя цена конверсии
         * Средняя рентабельность инвестиций
         * Средняя цена установки приложения
         * Недельный бюджет
         * Недельный пакет кликов
         * https://st.yandex-team.ru/DIRECT-46213
         *
         * @param {Object} strategy
         * @returns {boolean} если true параметр участвует в расчетах
         */
        // useEnableCPCHold: function(strategy) {
        //     return [
        //         'different_places',
        //         'autobudget_avg_click',
        //         'autobudget_avg_cpa',
        //         'autobudget_roi',
        //         'autobudget_avg_cpi',
        //         'autobudget',
        //         'autobudget_week_bundle'
        //     ].indexOf(!!(strategy || {}).search && strategy.search.name) < 0;
        // },

        //список полей объекта, которые должен поступать в качестве параметра в getText
        FIELDS_FOR_GENERATE_TEXT: [
            'ContextLimit', 'enable_cpc_hold', 'ContextPriceCoef',
            'isDiffPlaces', 'areStrategyDependableShows'
        ]
    }
});
