describe('i-utils__crypta', function() {

    describe('splitSegmentsByType', function() {

        it('Если массив пуст, вернет пустой объект', function() {
            expect(u['crypta'].splitSegmentsByType([])).to.be.deep.eq({});
        });

        it('Должен отнести тип social_demo к social-demo', function() {
            expect(u['crypta'].splitSegmentsByType([
                {
                    id: 1,
                    type: 'social_demo'
                }
            ])).to.be.deep.eq({
                'social-demo': [
                    {
                        id: 1,
                        type: 'social_demo'
                    }
                ]
            });
        });

        it('Должен отнести тип social_demo к social-demo (неск. элементов)', function() {
            expect(u['crypta'].splitSegmentsByType([
                {
                    id: 1,
                    type: 'social_demo'
                },
                {
                    id: 2,
                    type: 'social_demo'
                }
            ])).to.be.deep.eq({
                'social-demo': [
                    {
                        id: 1,
                        type: 'social_demo'
                    },
                    {
                        id: 2,
                        type: 'social_demo'
                    }
                ]
            });

        });

    });

});
