u.register({

    crypta: {

        /**
         * @typedef {'social_demo'|'family'|'interests'} CryptaTypeServer
         */

        /**
         * @typedef {'social-demo'|'family'|'interests'} CryptaType
         */

        segmentsMapping: {
            social_demo: 'social-demo',
            family: 'family',
            interests: 'interests',
            behaviors: 'behaviors',
            audio_genres: 'audio-genres'
        },

        segmentsNamesMapping: {
            social_demo: iget2('i-utils', 'crypta-soc-demo-profile', 'Социально-демографический профиль'),
            family: iget2('i-utils', 'crypta-family', 'Семейное положение, дети, профессия'),
            interests: iget2('i-utils', 'crypta-interests', 'Интересы'),
            metrika: iget2('i-utils', 'crypta-audience-and-metrika', 'Яндекс.Аудитории и Яндекс.Метрика'),
            behaviors: iget2('i-utils', 'crypta-behaviors', 'Поведенческие признаки'),
            audio_genres: iget2('i-utils', 'crypta-audio-genres', 'Жанры')
        },

        periodMapping: {
            all: iget2('i-utils', 'period-all', 'За любой период'),
            short_term: iget2('i-utils', 'period-short', 'Краткосрочные'),
            long_term: iget2('i-utils', 'period-long', 'Долгосрочные')
        },

        /**
         * @typedef {Object} RetConditionGoal
         *
         * @property {Number} id - идентификатор
         * @property {CryptaTypeServer | String} type - тип
         * @property {String} name
         * @property {Number} [time]
         */

        /**
         * @typedef {Object} RetConditionGroup
         *
         * @property {Array<RetConditionGoal>} goals
         * @property {'or'|'and'|'not'} type
         */

        /**
         * @typedef {Object} RetCondition
         *
         * @property {Number} id
         * @property {Array<RetConditionGroup>} conditions
         * @property {String} name
         * @property {String} description
         * @property {'interests'|'metrika_goals'} type
         * @property {Number} is_accessible -  доступно или нет
         */

        /**
         * @typedef {Object} CryptaSegmentServer
         *
         * @property {Number} id
         * @property {Number} parent_id - ID сегмента крипты, для тех у кого нет родителя = 0
         * @property {String} name - название сегмента, с учетом языка пользователя
         * @property {String} description - описание сегмента, с учетом языка пользователя
         * @property {String} type - тип сегмента
         */

        /**
         * @typedef {Object} CryptaSegment
         *
         * @property {Number} id
         * @property {Number} parent_id - ID сегмента крипты, для тех у кого нет родителя = 0
         * @property {String} name - название сегмента, с учетом языка пользователя
         * @property {String} description - описание сегмента, с учетом языка пользователя
         * @property {String} type - тип сегмента
         * @property {Boolean|null} can_select_all - возможность выбора всех сегментов в группе
         * @property {Boolean} checked - выбран/нет
         */

        /**
         * Разбивает сегменты по типам
         * @param {Array<CryptaSegmentServer>} segments
         * @return {{
         *    [CryptaType]: Array<CryptaSegmentServer>
         * }}
         */
        splitSegmentsByType: function(segments) {
            var result = {};

            segments.forEach(function(segment) {
                var type = this.segmentsMapping[segment.type] || segment.type;

                result[type] || (result[type] = []);
                result[type].push(segment);
            }, this);

            return result;
        },

        /**
         * Высчитывает формулу выбранных сегментов, для сегментов family и behaviors
         *
         * @return {Array<RetConditionGroup>}
         */
        calcSimpleSegmentsGroups: function(segments) {
            var groups = [],
                types = {};

            segments
                .filter(function(segment) {
                    return segment.checked;
                })
                .forEach(function(segment) {
                    types[segment.parent_id] || (types[segment.parent_id] = []);
                    types[segment.parent_id].push(segment.id);
                });

            Object.keys(types).forEach(function(key) {
                var group = { type: 'or', goals: [] };

                types[key].forEach(function(id) {
                    group.goals.push({ id: id });
                });

                groups.push(group);
            });

            return groups;
        },

        /**
         * Формирует текст свертки, для сегментов family и behaviors
         *
         * @param {Array<CryptaSegment>} segments - состояния сегментов формы
         *
         * @returns {String}
         */
        calcSimpleSegmentsText: function(segments) {
            var summary = {},
                checked = segments.filter(function(t) { return t.checked });

            checked.forEach(function(segment) {
                summary[segment.parent_id] || (summary[segment.parent_id] = []);
                summary[segment.parent_id].push(segment.name);
            });

            return Object.keys(summary).map(function(parent_id) {
                var parent = u._.find(segments, function(segment) {
                    return segment.id === Number(parent_id);
                });

                return parent.name + ': ' + summary[parent_id].join(', ');
            }).join('; ');
        }

    }
});
