u.register(/** @namespace u */{
    /**
     * Функция возвращает валюту по её коду
     * @param {String} currency код валюты
     * @returns {Object} объект валюты
     * @deprecated  - вредная функция. Отдает объект, знание о внутреннем устройстве которого, должно быть скрыто
     * вместо нее можно использовать
     *
     * todo выпилить 3-и использования
     */
    getCurrency: function(currency) {
        return window.currencies[currency];
    },

    /**
     * Функция вывода строки с сокращённым именем валюты, например 'руб.'
     * @param {String} currency код валюты
     * @returns {String} имя валюты
     * @deprecated u.currencies.getName
     *
     * todo 9 использований, заменить на u.currencies.getName
     */
    formatCurrency: function(currency) {
        return BEM.blocks['i-utils'].getCurrency(currency).name;
    },

    /**
     * Функция для вывода определённой суммы денег, в определённой валюте
     * @param {String} currency код валюты
     * @param {Number|String} sum сумма денег
     * @param {Object} [opts] дополнительные параметры форматирования {delim: '&nbsp', nds: 1}
     * @param {String} [opts.delim] разделитель между числом и названием валюты
     * @param {Number|undefined} [opts.nds] указывать ли информацию о НДС
     * (1 - включая НДС, 0 - без учёта НДС, undefined - ничего не пишем про НДС)
     * @returns {String} сумма денег в валюте
     * @deprecated
     *
     * todo 5 использований  заменить на u.currencies.formatSum
     */
    formatSumOfMoney: function(currency, sum, opts) {
        var delim = opts && opts.delim || ' ';

        return sum + delim + BEM.blocks['i-utils'].formatCurrency(currency) +
            (opts && opts.nds !== undefined ?
                delim + (opts.nds ? iget2('i-utils', 'vklyuchaya-nds', 'включая НДС') : iget2('i-utils', 'bez-uchyota-nds', 'без учёта НДС')) :
                '');
    }
});
