u.register({
    copyGroups: function(login, cid, pids, copyAndGoEdit) {
        var dna = window.dna;
        if (dna === undefined) {
            throw new Error('dna is not defined');
        }

        var mutationExecutor = dna.utils.getGroupsMutationExecutor(login);

        mutationExecutor
            .duplicateGroups({
                destinationCampaignId: cid,
                adGroupIds: pids
            }, login)
            .then(function(result) {
                var copiedAdGroupIds = result.copyAdGroups.copiedAdGroupIds,
                    goToGroupsEdit = function() {
                        window.location = copyAndGoEdit ?
                            u.getEditGroupInNewInterfaceUrl(false, {
                                cid: cid,
                                adgroupId: copiedAdGroupIds.join(','),
                                ulogin: login,
                            }) :
                            u.getUrl('showCamp', {
                                ulogin: login,
                                cid: cid,
                                tab: 'all',
                                search_by: 'group',
                                search_banner: copiedAdGroupIds.join(',')
                            });
                    };

                if (copiedAdGroupIds.length === 0) {
                    throw new Error();
                } else if (copiedAdGroupIds.length < pids.length) {
                    BEM.blocks['b-user-dialog'].alert(
                        iget2('b-campaign-info', 'not-all-copied-warning', 'Скопировано {copied} из {total} групп.', {
                            copied: copiedAdGroupIds.length,
                            total: pids.length // TODO падежи
                        }),
                        {
                            onConfirm: goToGroupsEdit
                        }
                    );
                } else {
                    goToGroupsEdit();
                }
            })
            .catch(function(e) {
                var message = e.message || iget2('b-campaign-info', 'general-copy-error', 'Во время копирования произошла ошибка. Попробуйте позже');
                BEM.blocks['b-user-dialog'].alert(message);
            });
    },

    createDevInfo: function(data) {
        var devInfo = {
                isBeta: data.is_beta,
                isProduction: data.is_production,
                svn: {}
            },
            svnInfo = data.svn_info || {};

        if (data.is_beta) {
            devInfo.svn = {
                branch: svnInfo.branch,
                revision: svnInfo.revision
            };

            devInfo.dbInfo = {
                configuration: data.CONFIGURATION,
                shard: data.SHARD
            };

            devInfo.betaNumber = data.server_name.split('.')[0];
        }

        return devInfo;
    },

    getUserInfo: function(data) {
        var defaultUid = data.UID,
            login = data.uname,
            blackboxUsers = data.blackbox_users,
            accounts = [];

        // Для анонимных пользователей
        if (!defaultUid || !login) {
            return;
        }

        // На случай, если запрос в blackbox был без multisession
        if (blackboxUsers) {
            accounts = Object.keys(blackboxUsers)
                .map(function(uid) {
                    return this.getUserAccountInfo(blackboxUsers[uid]);
                }, this)
                .filter(Boolean);

            if (accounts.length > 0) {
                var uids = accounts.map(function(account) {
                    return account.uid;
                });

                if (uids.indexOf(defaultUid) === -1) {
                    defaultUid = uids[0];
                }
            }
        }

        if (accounts.length === 0) {
            accounts = [
                this.getUserAccountInfo({
                    uid: defaultUid,
                    login: login,
                    display_name: data.display_name,
                    'address-list': data.address_list
                })
            ];
        }

        return {
            accounts: accounts,
            defaultUid: defaultUid,
            canAddMore: data.allow_more_users === '1'
        };
    },

    getUserAccountInfo: function(account) {
        var uid = this.getUserAccountInfoField(account.uid),
            login = this.getUserAccountInfoField(account.login),
            displayName = account.display_name || {},
            avatar = displayName.avatar || {},
            emails = (account['address-list'] && account['address-list'].address) || [],
            defaultEmail = emails.find(function(email) {
                return email.default === '1';
            });

        if (!uid || !login) {
            return;
        }

        return {
            uid: uid,
            login: login,
            defaultEmail: this.getUserAccountInfoField(defaultEmail),
            displayName: {
                name: this.getUserAccountInfoField(displayName.name, login),
                avatarId: this.getUserAccountInfoField(avatar.default, '0/0-0')
            }
        };
    },

    getUserAccountInfoField: function(field, defaultValue) {
        if (typeof field === 'object' && field.content) {
            field = field.content;
        }

        return field || defaultValue;
    }
})
