/**
 * @typedef {Object} DynamicConditionGoal
 * @property {String} type @see dynamicGroupsData.types
 * @property {String} kind @see dynamicGroupsData.kinds
 * @property {String} value
 */

u.register({
    dynamicGroupsData: {
        types: [
            'title',
            'content',
            'domain',
            'URL',
            'URL_prodlist',
            'any',
            ''
        ],
        kinds: [
            'exact',
            'not_exact',
            'match',
            'not_match',
            'equals',
            'not_equals',
            ''
        ],
        typeTitles: {
            URL_prodlist: iget2('i-utils', 'url-spiska-predlozheniy', 'URL списка предложений'),
            URL: iget2('i-utils', 'ssylka-na-tovar', 'Ссылка на товар'),
            title: iget2('i-utils', 'zagolovok-stranicy', 'Заголовок страницы'),
            content: iget2('i-utils', 'kontent-stranicy', 'Контент страницы'),
            domain: iget2('i-utils', 'domen', 'Домен')
        },
        kindTitles: {
            exact: iget2('i-utils', 'soderzhit', 'содержит'), // строго содержит
            not_exact: iget2('i-utils', 'ne-soderzhit', 'не содержит'), // строго не содержит
            match: iget2('i-utils', 'soderzhit', 'содержит'), // сейчас отключен: DIRECT-48036
            not_match: iget2('i-utils', 'ne-soderzhit', 'не содержит'), // сейчас отключен: DIRECT-48036
            equals: iget2('i-utils', 'ravno', 'равно'),
            not_equals: iget2('i-utils', 'ne-ravno', 'не равно')
        },
        /**
         * Идентификатор в статистике
         */
        statisticsContextType: 7,
        /**
         * Возвращает заголовок динамического  объявления
         * @returns {String}
         */
        getBannerTitle: function() {
            return iget2('i-utils', 'dinamicheskiy-zagolovok', '{Динамический заголовок}');
        },
        /**
         * Возвращает описание правила нацеливания
         * @param {DynamicConditionGoal} goal
         * @returns {String}
         */
        getSummaryText: function(goal) {
            // todo@dima117a: выполняем сопоставление, т.к. на сервере приходит массив строк, а на клиенте - массив объектов { value: '...'}
            var strValue = (goal.value || []).map(function(item) {
                return item.hasOwnProperty('value') ? item.value : item;
            }).join(', ');

            return goal.type == 'any' ?
                iget2('i-utils', 'vse-stranicy-sayta', 'Все страницы сайта') :
                [
                    u.dynamicGroupsData.typeTitles[goal.type], '—',
                    u.dynamicGroupsData.kindTitles[goal.kind],
                    '"' + u.escapeHTML(strValue) + '"'
                ].join(' ');
        },
        /**
         * Возвращает описание условия нацеливания
         * @param {DynamicConditionGoal[]} condition список правил нацеливания
         * @param {Boolean} truncate обрезать ли результат
         * @returns {String}
         */
        getConditionSummaryText: function(condition, truncate) {
            var result = condition.map(u.dynamicGroupsData.getSummaryText).join(', ');
            return truncate ? u.hellipCut(result, 80, '...') : result;
        }
    }
});
