describe('i-utils__error', function() {
    var fakeErrors = {
            server: {
                "groups": {
                    "generic_errors": [{"text": "error 1"}],
                    "array_errors": [
                        {
                            "generic_errors": [{"text": "error 2"}],
                            "object_errors": {
                                "banners": {
                                    "array_errors": [
                                        null,
                                        {
                                            "object_errors": {
                                                "creative": [
                                                    {
                                                        "text": "Геотаргетинг задан неправильно",
                                                        "description": "Геотаргетинг группы шире списка стран её cмарт-баннеров"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                },
                                "feed_id": [
                                    {
                                        "text": "Объект не найден",
                                        "description": "Указанный фид не существует"
                                    }
                                ],
                                "group_name": [
                                    {
                                        "text": "Неверный формат",
                                        "description": "Имя группы не может быть пустой строкой \"\""
                                    }
                                ],
                                "performance_filters": {
                                    "generic_errors": [{"text": "error 3"}],
                                    "array_errors": [
                                        {
                                            "generic_errors": [{"text": "error 4"}],
                                            "object_errors": {
                                                "filter_name": [
                                                    {
                                                        "text": "Используются недопустимые символы",
                                                        "description": "В поле \"Название фильтра\" допускается использование букв латинского, турецкого, русского, украинского, казахского алфавитов, цифр и знаков пунктуации"
                                                    },
                                                    {
                                                        "text": "Используются недопустимые символы",
                                                        "description": "В поле \"Название фильтра\" допускается использование букв латинского, турецкого, русского, украинского, казахского алфавитов, цифр и знаков пунктуации"
                                                    }
                                                ],
                                                "condition": {
                                                    "generic_errors": [{"text": "error 5"}],
                                                    "array_errors": [
                                                        null,
                                                        null,
                                                        [
                                                            {
                                                                "text": "Неверный формат",
                                                                "description": "Неправильный формат правила: значение содержит недопустимые символы"
                                                            },
                                                            {
                                                                "text": "Неверный формат",
                                                                "description": "Неправильный формат правила: значение содержит недопустимые символы"
                                                            }
                                                        ]
                                                    ]
                                                }
                                            }
                                        }, null
                                    ]
                                }
                            }
                        }
                    ]
                }
            },
            client: [
                {
                    "group_name": [{ "text": "Необходимо указать название группы"}],
                    "performance_filters": [{ "text": "Добавьте в группу фильтры"}]
                }
            ]
        },
        flattenExpected = {
            server: {
                "groups": [{ "text": "error 1", "_path": "groups" }],
                "groups[0]": [{ "text": "error 2", "_path": "groups[0]" }], "groups[0].banners[1].creative": [
                    {
                        "text": "Геотаргетинг задан неправильно",
                        "description": "Геотаргетинг группы шире списка стран её cмарт-баннеров",
                        "_path": "groups[0].banners[1].creative"
                    }
                ], "groups[0].feed_id": [
                    {
                        "text": "Объект не найден", "description": "Указанный фид не существует",
                        "_path": "groups[0].feed_id"
                    }
                ], "groups[0].group_name": [
                    {
                        "text": "Неверный формат", "description": "Имя группы не может быть пустой строкой \"\"",
                        "_path": "groups[0].group_name"
                    }
                ], "groups[0].performance_filters": [{ "text": "error 3", "_path": "groups[0].performance_filters" }],
                "groups[0].performance_filters[0]": [
                    {
                        "text": "error 4", "_path": "groups[0].performance_filters[0]"
                    }
                ], "groups[0].performance_filters[0].filter_name": [
                    {
                        "text": "Используются недопустимые символы",
                        "description": "В поле \"Название фильтра\" допускается использование букв латинского, турецкого, русского, украинского, казахского алфавитов, цифр и знаков пунктуации",
                        "_path": "groups[0].performance_filters[0].filter_name"
                    }, {
                        "text": "Используются недопустимые символы",
                        "description": "В поле \"Название фильтра\" допускается использование букв латинского, турецкого, русского, украинского, казахского алфавитов, цифр и знаков пунктуации",
                        "_path": "groups[0].performance_filters[0].filter_name"
                    }
                ], "groups[0].performance_filters[0].condition": [
                    {
                        "text": "error 5", "_path": "groups[0].performance_filters[0].condition"
                    }
                ], "groups[0].performance_filters[0].condition[2]": [
                    {
                        "text": "Неверный формат",
                        "description": "Неправильный формат правила: значение содержит недопустимые символы",
                        "_path": "groups[0].performance_filters[0].condition[2]"
                    }, {
                        "text": "Неверный формат",
                        "description": "Неправильный формат правила: значение содержит недопустимые символы",
                        "_path": "groups[0].performance_filters[0].condition[2]"
                    }
                ]
            },
            client: {
                "groups[0].group_name": [{ "text": "Необходимо указать название группы", "_path": "groups[0].group_name" }],
                "groups[0].performance_filters": [{ "text": "Добавьте в группу фильтры", "_path": "groups[0].performance_filters" }]
            }
        };

    describe('Плоский список ошибок соответствует ожидаемому', function() {

        it('при обработке вложенного объекта ошибки от сервера', function() {
            expect(u.error.flattenServer(fakeErrors.server)).to.deep.equal(flattenExpected.server);
        });

        it('при обработке вложенного объекта ошибки клиентской валидации', function() {
            expect(u.error.flattenClient(fakeErrors.client, 'groups')).to.deep.equal(flattenExpected.client);
        });

    });

    describe('Построение пути ошибок', function() {

        it('createPathBuilder(path) возвращает функцию-генератор пути', function() {
            expect(u.error.createPathBuilder()).to.be.a('function');
        });

        [
            [undefined, [], ''],
            [undefined, [''], ''],
            ['', [], ''],
            ['', [1], '[1]'],
            ['', ['1'], '[1]'],
            ['', ['performance_filters'], 'performance_filters'],
            ['', ['performance_filters', 1, 'condition'], 'performance_filters[1].condition'],
            ['', [0, 'performance_filters', 1, 'condition'], '[0].performance_filters[1].condition'],
            ['groups', [0, 'performance_filters', 1, 'condition'], 'groups[0].performance_filters[1].condition']
        ].forEach(u._.spread(function(basePath, args, expected) {
            var formatArgs = function(args) {
                    return ['(', ')'].join(args.map(function(arg) {
                        if (typeof arg == 'number') return arg;
                        if (typeof arg == 'string') return '\'' + arg + '\'';
                        return '';
                    }).join(', '))
                },
                title = 'createPathBuilder' + formatArgs([basePath]) + formatArgs(args) + ' возвращает ' + (expected || 'пустую строку');

            it(title, function() {
                var builder = basePath ? u.error.createPathBuilder(basePath) : u.error.createPathBuilder();

                expect(builder.apply(null, args)).to.be.equals(expected);
            });

        }));

    });

    describe('clientToUniversal()', function() {
        it('должен конвертировать поля - примитивные типы в поля в object_errors', function() {
            var errorText = "Необходимо указать название группы",
                modelError = {
                    "errorFields": [
                        "group_name"
                    ],
                    "errors": [
                        {
                            "rule": "required",
                            "text": errorText
                        }
                    ],
                    "errorsData": {
                        "group_name": [
                            {
                                "rule": "required",
                                "text": errorText
                            }
                        ]
                    }
                };

            expect(u.error.clientToUniversal(modelError)).to.be.eql({
                "object_errors": {
                    "group_name": [{ "text": errorText }]
                }
            });
        });

        it('должен возвращать массив результатов в array_errors в ответ на запрос конвертации массива', function() {
            var errorText = "Необходимо указать название группы",
                modelsErrors = [
                    {
                        "errorFields": ["group_name"],
                        "errors": [{ "rule": "required", "text": errorText }],
                        "errorsData": {
                            "group_name": [{ "rule": "required", "text": errorText }]
                        }
                    },
                    {
                        "errorFields": ["group_name"],
                        "errors": [{ "rule": "required", "text": errorText }],
                        "errorsData": {
                            "group_name": [{ "rule": "required", "text": errorText }]
                        }
                    }
                ];

            expect(u.error.clientToUniversal(modelsErrors)).to.be.eql({
                array_errors: [
                    {
                        "object_errors": {
                            "group_name": [{ "text": errorText }]
                        }
                    },
                    {
                        "object_errors": {
                            "group_name": [{ "text": errorText }]
                        }
                    }
                ]
            });
        });

        it('должен поддерживать несколько ошибок относящихся к одному полю', function() {
            var errorText1 = 'Превышена допустимая длина текста объявления в 75 символов',
                errorText2 = 'В тексте динамических объявлений недопустимы непрерывные строки длиной более 23 знаков',
                modelErrors = {
                    "errorFields": ["body"],
                    "errors": [
                        {
                            "rule": "tooLong",
                            "text": errorText1
                        },
                        {
                            "rule": "noLongWords",
                            "text": errorText2
                        }
                    ],
                    "errorsData": {
                        "body": [
                            {
                                "rule": "tooLong",
                                "text": errorText1
                            },
                            {
                                "rule": "noLongWords",
                                "text": errorText2
                            }
                        ]
                    }
                };

            expect(u.error.clientToUniversal(modelErrors)).to.be.eql({
                "object_errors": {
                    "body": [{ "text": errorText1 }, { "text": errorText2 }]
                }
            });
        });

        it('должен возращать пустой object_errors на объект успешной валидации', function() {
            expect(u.error.clientToUniversal({ valid: true })).to.be.eql({ object_errors: {} });
        });
    });

});
