(function() {
    var clientFeaturesMap,
        operatorFeaturesMap,
        makeMapFunc = function(acc, featureName) {
            acc[featureName.toLowerCase()] = true;

            return acc;
        },
        getClientFeaturesMap = function() {
            return clientFeaturesMap ||
                (clientFeaturesMap = (u.consts('clientFeaturesAll') || []).reduce(makeMapFunc, {}));
        },
        getOperatorFeaturesMap = function() {
            return operatorFeaturesMap ||
                (operatorFeaturesMap = (u.consts('operatorFeaturesAll') || []).reduce(makeMapFunc, {}));
        };

    u.register({

        /**
         * Проверяет включена ли фича на клиента
         * @param {string} featureName
         * @returns {boolean}
         */
        hasClientFeature: function(featureName) {
            return Boolean(getClientFeaturesMap()[featureName.toLowerCase()]);
        },

        /**
         * Проверяет включена ли фича на оператора
         * @param {string} featureName
         * @returns {boolean}
         */
        hasOperatorFeature: function(featureName) {
            return Boolean(getOperatorFeaturesMap()[featureName.toLowerCase()]);
        }
    });
})();
