u.register({
    feedData: {
        source: ['', 'url', 'file', 'site'],
        status: ['', 'New', 'Outdated', 'Updating', 'Done', 'Error'],
        businessType: [
            'retail',
            'hotels',
            'auto',
            'realty',
            'flights',
            'news',
            'other'
        ],
        defaultBusinessType: 'retail',
        feedType: [
            'YandexMarket',
            'GoogleMerchant',
            'CriteoTurkey',
            'AliExpress',
            'GoogleHotels',
            'TravelBooking',
            'AutoRu',
            'YandexRealty',
            'GoogleFlights',
            'YandexZen',
            'Alibaba',
            'TurkeyTeknosa',
            'TurkeyJollyTur',
            'TurkeyClient1',
            'TurkeyClient2',
            'TurkeyClient3',
            'TurkeyClient4',
            'TurkeyClient5',
            'TurkeyClient6',
            'TurkeyClient7',
            'TurkeyClient8',
            'TurkeyClient9',
            'TurkeyClient10',
            'TurkeyClient11',
            'TurkeyClient12',
            'TurkeyClient13',
            'TurkeyClient14',
            'TurkeyClient15',
            'TurkeyClient16',
            'TurkeyClient17',
            'TurkeyClient18',
            'TurkeyClient19',
            'TurkeyClient20',
            'TurkeyClient21',
            'TurkeyClient22',
            'TurkeyClient23',
            'TurkeyClient24',
            'TurkeyClient25',
            'YandexCustom',
            'GoogleCustom',
            'GoogleTravel'
        ],
        defaultFeedType: 'YandexMarket'
    },
    mapFeedFromDNA: {
        source: {
            URL: 'url',
            FILE: 'file',
            SITE: 'site'
        },
        businessType: {
            RETAIL: 'retail',
            HOTELS: 'hotels',
            AUTO: 'auto',
            REALTY: 'realty',
            FLIGHTS: 'flights',
            NEWS: 'news',
            OTHER: 'other',
        },
        updateStatus: {
            NEW: 'New',
            OUTDATED: 'Outdated',
            UPDATING: 'Updating',
            DONE: 'Done',
            ERROR: 'Error'
        },
        feedType: {
            ALIBABA: 'Alibaba',
            ALIEXPRESS: 'AliExpress',
            AUTO_RU: 'AutoRu',
            CRITEO_TURKEY: 'CriteoTurkey',
            GOOGLE_CUSTOM: 'GoogleCustom',
            GOOGLE_FLIGHTS: 'GoogleFlights',
            GOOGLE_HOTELS: 'GoogleHotels',
            GOOGLE_MERCHANT: 'GoogleMerchant',
            GOOGLE_TRAVEL: 'GoogleTravel',
            TRAVEL_BOOKING: 'TravelBooking',
            TURKEY_CLIENT_1: 'TurkeyClient1',
            TURKEY_CLIENT_10: 'TurkeyClient10',
            TURKEY_CLIENT_11: 'TurkeyClient11',
            TURKEY_CLIENT_12: 'TurkeyClient12',
            TURKEY_CLIENT_13: 'TurkeyClient13',
            TURKEY_CLIENT_14: 'TurkeyClient14',
            TURKEY_CLIENT_15: 'TurkeyClient15',
            TURKEY_CLIENT_16: 'TurkeyClient16',
            TURKEY_CLIENT_17: 'TurkeyClient17',
            TURKEY_CLIENT_18: 'TurkeyClient18',
            TURKEY_CLIENT_19: 'TurkeyClient19',
            TURKEY_CLIENT_2: 'TurkeyClient2',
            TURKEY_CLIENT_20: 'TurkeyClient20',
            TURKEY_CLIENT_21: 'TurkeyClient21',
            TURKEY_CLIENT_22: 'TurkeyClient22',
            TURKEY_CLIENT_23: 'TurkeyClient23',
            TURKEY_CLIENT_24: 'TurkeyClient24',
            TURKEY_CLIENT_25: 'TurkeyClient25',
            TURKEY_CLIENT_3: 'TurkeyClient3',
            TURKEY_CLIENT_4: 'TurkeyClient4',
            TURKEY_CLIENT_5: 'TurkeyClient5',
            TURKEY_CLIENT_6: 'TurkeyClient6',
            TURKEY_CLIENT_7: 'TurkeyClient7',
            TURKEY_CLIENT_8: 'TurkeyClient8',
            TURKEY_CLIENT_9: 'TurkeyClient9',
            TURKEY_JOLLY_TUR: 'TurkeyJollyTur',
            TURKEY_TEKNOSA: 'TurkeyTeknosa',
            YANDEX_CUSTOM: 'YandexCustom',
            YANDEX_MARKET: 'YandexMarket',
            YANDEX_REALTY: 'YandexRealty',
            YANDEX_ZEN: 'YandexZen'
        }

    },

    mapFeedFromDNAApi: function(res) {
        var data = res.data.client.feeds;

        return {
            items: data.rowset.map(function(feed) {
                return {
                    business_type: u.mapFeedFromDNA.businessType[feed.businessType],
                    campaigns: feed.campaigns.map(function(campaign) {
                        return {
                            campaign_name: campaign.name,
                            id: campaign.id
                        };
                    }),
                    hasPassword: feed.hasPassword,
                    feed_id: feed.id,
                    feed_type: u.mapFeedFromDNA.feedType[feed.feedType],
                    fetch_errors_count: feed.fetchErrorsCount,
                    filename: feed.fileName,
                    is_remove_utm: feed.isRemoveUtm ? '1' : '0',
                    last_change: feed.lastChange,
                    login: feed.login,
                    name: feed.name,
                    offers_count: feed.offersCount,
                    source: u.mapFeedFromDNA.source[feed.source],
                    update_status: u.mapFeedFromDNA.updateStatus[feed.updateStatus],
                    display_status: u.mapFeedFromDNA.updateStatus[feed.updateStatus],
                    url: feed.url,
                    isReadOnly: feed.isReadOnly
                }
            }),
            total_count: data.totalCount
        };
    },

    getFeedBusinessTypeText: function(code) {
        return {
            retail: iget2('i-utils', 'roznichnaya-torgovlya', 'Розничная торговля'),
            hotels: iget2('i-utils', 'oteli', 'Отели'),
            auto: iget2('i-utils', 'avtomobili', 'Автомобили'),
            realty: iget2('i-utils', 'nedvizhimost', 'Недвижимость'),
            flights: iget2('i-utils', 'aviabilety', 'Авиабилеты'),
            news: iget2('i-utils', 'novosti', 'Новости'),
            other: iget2('i-utils', 'other', 'Другой бизнес')
        }[code];
    }
});
