u.register({
    feedFilterData: {

        getTabs: function(feedType, businessType) {
            var tabsList = u._.get(this.tabsRules, [businessType, feedType]) || [];

            return u._.filter(this.tabs, function(tab) { return !!~tabsList.indexOf(tab.value); });
        },

        tabsRules: {
            retail: {
                YandexMarket: ['tree', 'condition'],
                GoogleMerchant: ['all-products','condition'],
                CriteoTurkey: ['all-products'],
                AliExpress: ['all-products'],
                Alibaba: ['all-products'],
                TurkeyTeknosa: ['all-products'],
                TurkeyJollyTur: ['all-products'],
                TurkeyClient1: ['all-products'],
                TurkeyClient2: ['all-products'],
                TurkeyClient3: ['all-products'],
                TurkeyClient4: ['all-products'],
                TurkeyClient5: ['all-products'],
                TurkeyClient6: ['all-products'],
                TurkeyClient7: ['all-products'],
                TurkeyClient8: ['all-products'],
                TurkeyClient9: ['all-products'],
                TurkeyClient10: ['all-products'],
                TurkeyClient11: ['all-products'],
                TurkeyClient12: ['all-products'],
                TurkeyClient13: ['all-products'],
                TurkeyClient14: ['all-products'],
                TurkeyClient15: ['all-products'],
                TurkeyClient16: ['all-products'],
                TurkeyClient17: ['all-products'],
                TurkeyClient18: ['all-products'],
                TurkeyClient19: ['all-products'],
                TurkeyClient20: ['all-products'],
                TurkeyClient21: ['all-products'],
                TurkeyClient22: ['all-products'],
                TurkeyClient23: ['all-products'],
                TurkeyClient24: ['all-products'],
                TurkeyClient25: ['all-products', 'condition'], // YandexMoneyPromocodes
                YandexCustom: ['tree', 'condition'],
                GoogleCustom: ['tree', 'condition'],
                GoogleTravel: ['tree', 'condition']
            },
            hotels: {
                GoogleHotels: ['all-products', 'condition'],
                TravelBooking: ['all-products', 'condition']
            },
            auto: {
                AutoRu: ['all-products', 'condition']
            },
            realty: {
                YandexRealty: ['all-products']
            },
            flights: {
                GoogleFlights: ['all-products']
            },
            news: {
                YandexZen: ['all-products']
            },
            other: {
                YandexCustom: ['all-products', 'condition'],
                GoogleCustom: ['all-products', 'condition'],
                GoogleTravel: ['all-products', 'condition'],
                YandexMarket: ['tree', 'condition']
            }
        },

        tabs: [
            {
                title: iget2('i-utils', 'derevo-kategoriy', 'Дерево категорий'),
                value: 'tree'
            },
            {
                title: iget2('i-utils', 'vybrat-vse', 'Выбрать все'),
                value: 'all-products'
            },
            {
                title: iget2('i-utils', 'usloviya', 'Условия'),
                value: 'condition'
            }
        ],

        rangeSeparator: '-',

        defaultTab: 'tree',

        field: [
            'id',
            'price',
            'categoryId',
            'url',
            'name',
            'model',
            'vendor'
        ],

        relation: [
            '>',
            '<',
            '==',
            'like',
            'not like',
            '<->'
        ],

        correlationRules: {
            id: ['<', '>', '==', '<->'],
            price: ['<', '>', '==', '<->'],
            categoryId: ['<', '>', '==', '<->'],
            url: ['like', 'not like'],
            name: ['like', 'not like'],
            model: ['like', 'not like'],
            vendor: ['like', 'not like']
        },

        correlationValueTypes: {
            '<': 'single',
            '>': 'single',
            '==': 'single',
            like: 'single',
            'not like': 'single',
            '<->': 'multi-range'
        },

        fieldTitles: {
            id: iget2('i-utils', 'id', 'ID'),
            price: iget2('i-utils', 'price', 'price'),
            categoryId: iget2('i-utils', 'category-id', 'category ID'),
            url: iget2('i-utils', 'url', 'URL'),
            name: iget2('i-utils', 'name', 'name'),
            model: iget2('i-utils', 'model', 'model'),
            vendor: iget2('i-utils', 'vendor', 'vendor')

        },

        targetAudienceTitles: {
            new_auditory: iget2('i-utils', 'look-alike', 'Look-alike'),
            product_page_visit: iget2('i-utils', 'retargeting-users', 'Ретаргетинг посетителей сайта'),
            same_products: iget2('i-utils', 'maximum-reach', 'Максимальный охват (Ретаргетинг + Look-alike)')
        },

        errorTexts: {
            notUnique: iget2('i-utils', 'uslovie-s-takim-sochetaniem', 'Условие с таким сочетанием правил уже существует в группе'),
            savingError: iget2('i-utils', 'pri-sohranenii-proizoshla-oshibka', 'При сохранении произошла ошибка, повторите попытку позже')
        },

        relationTitles: {
            '<': iget2('i-utils', 'menshe', 'меньше'),
            '>': iget2('i-utils', 'bolshe', 'больше'),
            '==': iget2('i-utils', 'ravno', 'равно'),
            like: iget2('i-utils', 'soderzhit', 'содержит'),
            'not like': iget2('i-utils', 'ne-soderzhit', 'не содержит'),
            '<->': iget2('i-utils', 'diapazon', 'диапазон')
        },

        sanitizeValue: function(val, type) {
            var isPrice = type == 'price';

            return isPrice ?
                val.replace(/[\/бБ<]/gi, ',').replace(/[\/юЮ>]/gi, '.') :
                val.replace(/[\/.юЮбБ<>]/gi, ',');
        },

        formatValue: function(val, type) {
            var isPrice = type == 'price',
                maxLength = { price: 20, id: 20, categoryId: 18 },
                precision = isPrice ? 2 : 0,
                number = Math.abs(parseFloat(val.slice(0, maxLength[type] || 20))),
                rawValue = u.numberFormatter.clear(number, {
                    fail: '',
                    precision: precision
                });

            return isPrice ?
                u.numberFormatter.roundFormatted(rawValue, {
                    precision: precision,
                    fail: null
                }) :
                rawValue.split('.')[0];
        },

        getRangeValidationRules: function(isRange, range, rulesNames) {
            var rangeSeparator = u.feedFilterData.rangeSeparator,
                isMinLessThemMax = range.every(function(item) {
                    var range = item.split(rangeSeparator),
                        result = true;

                    if (!!range[0] && !!range[1]) result = parseFloat(range[0]) < parseFloat(range[1]);

                    return result;
                }),
                rules = {
                    required: {
                        text: iget2('i-utils', 'zadayte-diapazon', 'Задайте диапазон'),
                        validate: function(val) {
                            return val.length && val.every(function(rangeItem) {
                                return rangeItem != rangeSeparator;
                            });
                        },
                        needToValidate: function() { return isRange }
                    },

                    maxMoreThemMin: {
                        text: iget2('i-utils', 'minimalnoe-znachenie-bolshe-ili', 'Минимальное значение больше или равно максимальному'),
                        validate: function() { return isMinLessThemMax }
                    }
                };

            return rulesNames.reduce(function(hash, item) {

                hash.rules[item] = rules[item];

                return hash;

            }, { rules: {} });
        },

        numFormatter: function(val, fieldType) {
            var clearVal = u.numberFormatter.clear(val);

            return !!val && !isNaN(clearVal) ?
                fieldType == 'price' ?
                    clearVal :
                    u.numberFormatter.format(clearVal, { exponentDelimiter: '', precision: 0 }) : '';
        },

        getRangeFields: function() {
            return Object.keys(u.feedFilterData.correlationRules).filter(function(key) {
                return u._.contains(u.feedFilterData.correlationRules[key], '<->');
            });
        },

        getStateString: function(field, relation, value) {
            return field + relation + (u._.isArray(value) ? value.join() : value);
        }

    }
});
