(function() {
    /**
     * Возвращает из "древовидного" массива "плоский"
     * Не изменяет исходный массив
     *
     * @example u.flatten([1, [2, [3, 4]]]) -> [1, 2, 3, 4]
     * @returns {Array}
     */
    u.register({
        flatten: function flatten(array) {
            var result = [];

            array.forEach(function(value) {
                Array.isArray(value) ?
                    result.push.apply(result, flatten(value)) :
                    result.push(value);
            });

            return result;
        }
    })
})();
