/**
 * Выполняясь в v8 (версии, используемой в директе), moment может вызвать segfault
 * Поэтому в некоторых местах нужно вместо moment использовать перловый format_date
 * После перехода на выполнение шаблонов в report renderer, ожидается что moment больше не будет выдавать segfault
 * Поэтому сейчас в "опасных" местах сделан вызов u.formatDate
 * u.formatDate автоматически поменяет реализацию на moment, когда начнет выполняться в report renderer
 */
u.register({
    /**
     * Функцию форматирования даты на замену u.formatDate
     * Не поддерживает следующие после первого параметры из format_date
     * @param {String} date строка даты, которую может распарсить momentjs
     * @returns {String}
     */
    formatDate: function(date) {
        if (!date) {
            return '';
        }
        /* globals data */
        return (typeof data != 'undefined' && data.format_date) ? // check-functions:ignore
            data.format_date(date) : // check-functions:ignore jshint:global
            u.moment(date).format('DD.MM.YYYY');
    }
});
