(function() {
    var methodMap = {
        inside: 'findBlockInside',
        on: 'findBlockOn',
        outside: 'findBlockOutside'
    };

    u.register({
        /**
         * Функция, в соответствии со schema находящая части блока
         * Должна вызываться в контексте блока, которые наделяет знанием о его составных частях
         * @param {Object} schema схема частей блока
         * @example
         * <pre>
         * u.graspSelf.call(this, {
         *     link: 'b-link on link',  -> this.link = this.findBlockOn('link', 'b-link');
         *     popup: 'popup inside',   -> this.popup = this.findBlockInside('popup');
         *     item: 'item'             -> this.item = this.elem('item');
         * });
         * </pre>
         * Перед schema можно указывать ?, в таком случае экспешен не стриггерится, если элемент не будет найден
         * Пример: '? b-link in link'
         * @todo случаи с findBlocks*
         */
        graspSelf: function(schema) {
            Object.keys(schema).forEach(function(key) {
                var params = schema[key].split(' '),
                    args,
                    part,
                    optional;

                if (params[0] === '?') {
                    optional = true;
                    params.splice(0,1);
                }

                if (params.length === 1) {
                    part = this.elem(params[0]);
                } else {
                    args = [params[0]];
                    params[2] && args.unshift(params[2]);
                    part = this[methodMap[params[1]]].apply(this, args);
                }

                if (part) {
                    this[key] = part;
                } else if (!optional) {
                    throw new Error('Cannot find ' + schema[key]);
                }
            }, this);
        }
    });
}());
