describe('i-utils__grasp-self', function() {
    var graspSelf = BEM.blocks['i-utils'].graspSelf,
        getDOMTree = function(json) {
            return BEM.DOM.init($(BEMHTML.apply(json)));
        };

    it('must find element inside', function() {
        var tree = getDOMTree({
                block: 'block',
                content: { elem: 'elem' }
            }),
            elem = tree.find('.block__elem'),
            block = tree.bem('block');

        graspSelf.call(block, {
            elem: 'elem'
        });

        expect(block.elem.is(elem)).to.be.equal(true);
    });

    it('must find block inside', function() {
        var tree = getDOMTree({
                block: 'block',
                content: { block: 'inner-block' }
            }),
            innerBlock = tree.find('.inner-block').bem('inner-block'),
            block = tree.bem('block');

        graspSelf.call(block, {
            innerBlock: 'inner-block inside'
        });

        expect((block.innerBlock == innerBlock)).to.be.equal(true);
    });

    it('must find block outside', function() {
        var tree = getDOMTree({
                block: 'outer-block',
                content: { block: 'block' }
            }),
            block = tree.find('.block').bem('block'),
            outerBlock = tree.bem('outer-block');

        graspSelf.call(block, {
            outerBlock: 'outer-block outside'
        });

        expect((block.outerBlock == outerBlock)).to.be.equal(true);
    });

    it('must find block on element', function() {
        var tree = getDOMTree({
                block: 'block',
                content: {
                    block: 'inner-block',
                    mix: [{ block: 'block', elem: 'elem' }]
                }
            }),
            innerBlock = tree.find('.inner-block').bem('inner-block'),
            block = tree.bem('block');

        graspSelf.call(block, {
            innerBlock: 'inner-block on elem'
        });

        expect((block.innerBlock == innerBlock)).to.be.equal(true);
    });

    it('must find block inside element', function() {
        var tree = getDOMTree({
                block: 'block',
                content: {
                    block: 'block',
                    elem: 'elem',
                    content: { block: 'inner-block' }
                }
            }),
            innerBlock = tree.find('.inner-block').bem('inner-block'),
            block = tree.bem('block');

        graspSelf.call(block, {
            innerBlock: 'inner-block inside elem'
        });

        expect((block.innerBlock == innerBlock)).to.be.equal(true);
    });
});
