(function() {
    u.register({

        /**
         * Возвращает массив с текстами и подсвеченными блоками
         * @param {String} text исходный текст
         * @param {String|RegExp} search искомый текст
         * @param {Object} params параметры обработки найденного
         * @param {Function} params.decorator функция-декоратор, возвращающая BEMJSON выделенного текста
         * @param {Boolean} [params.insensitive=true] нечувствительность к регистру при поиске текста
         * @param {Boolean} [params.global=true] глобальный поиск
         * @param {Boolean} [params.multiline=true] многострочный поиск
         * @return {BEMJSON[]}
         */
        highlight: function(text, search, params) {
            var regExp,
                found,
                options;

            if (!search) return [text];

            if (typeof params === 'function') {
                params = {
                    decorator: params
                };
            }

            if (search instanceof RegExp) {
                regExp = search;
            } else {
                typeof params.insensitive === 'boolean' || (params.insensitive = true);
                typeof params.global === 'boolean' || (params.global = true);
                typeof params.multiline === 'boolean' || (params.multiline = true);

                options = '';

                params.insensitive && (options += 'i');
                params.global && (options += 'g');
                params.multiline && (options += 'm');

                regExp = new RegExp(u.escape.regExp(search), options);
            }

            found = [];

            return text
                // поиск по регулярному выражению текста с сохранением регистра
                .replace(regExp, function(search) {
                    found.push(search);

                    // заменяем табом как "не вводимым" символом
                    return '\t';
                })
                // расщепление по табу
                .split(/\t/)
                // и вставка в места расщепления декорированных найденных строк
                .reduce(function(parts, text, index) {
                    text && parts.push(text);

                    index < found.length && parts.push(params.decorator(found[index]));

                    return parts;
                }, []);
        }
    });
})();
