describe('i-utils__i18n:', function() {

    describe('u.iget2Pluralize:', function() {
        
        var params,
            iPlu = u.iget2Pluralize;

        beforeEach(function() {
            params = {
                some: 'яблока',
                many: 'яблок'
            };
        });

        // none
        it('для 0 должна использоваться форма none, если она существует', function() {
            expect(iPlu('яблоко', u._.extend(params, { count: 0, none: 'нет яблок' }))).to.equal(params.none);
        });

        it('для 0 должна использоваться форма many, если форма none не существует', function() {
            expect(iPlu('яблоко', u._.extend(params, { count: 0 }))).to.equal(params.many);
        });

        // single
        [1, 21, 101].forEach(function(count) {
            it('для ' + count + ' должна использоваться форма ед.ч.', function() {
                expect(iPlu('яблоко', u._.extend(params, { count: count }))).to.equal('яблоко');
            });
        });

        // some
        [2, 3, 4, 144].forEach(function(count) {
            it('для ' + count + 'должна использоваться форма some мн.ч.', function() {
                expect(iPlu('яблоко', u._.extend(params, { count: count }))).to.equal(params.some);
            });
        });

        // many
        [5, 10, 11, 12, 15, 20, 25].forEach(function(count) {
            it('для ' + count + 'должна использоваться форма many мн.ч.', function() {
                expect(iPlu('яблоко', u._.extend(params, { count: count }))).to.equal(params.many);
            });
        });

    });

});
