(function() {
    var placeholder = '__PLACEHOLDER__',
        uniqMarker = '__MARKER__',

        /**
         * Фолбек для случая когда BEM.I18N не задекларированы ключи
         * @param {String} keyset
         * @param {String} key
         * @param {String} [phrase]
         * @param {Object} [params]
         * @param {Object} [placeholderParams]
         * @returns {String}
         */
        fallback = function(keyset, key, phrase, params, placeholderParams) {
            if (typeof params === 'object') {
                var splitter = function(sub) {
                    return uniqMarker + sub + uniqMarker;
                };

                params.count >= 0 && (phrase = u.iget2Pluralize(phrase, params));

                return phrase
                    .replace(/(\{[a-zA-Z0-9\-_]*\})/g, splitter)
                    .split(uniqMarker)
                    .filter(function(key) {
                        return key != '';
                    })
                    .map(function(part) {
                        var r = part.match(/\{([a-zA-Z0-9\-_]*)\}/);

                        if (r === null) return part;

                        var value = (placeholderParams && placeholderParams[r[1]]) || params[r[1]];

                        if (typeof value === 'function') {
                            return value();
                        } else {
                            value.block || (value.block = keyset);

                            return value;
                        }
                    })
                    .join('');
            }

            return phrase || key;
        },

        i18nWithFallback = function(keyset, key, phrase, params, placeholderParams) {
            // Если ключа нет, то BEM.I18N возвращает пустую строку
            var res = BEM.I18N ? BEM.I18N(keyset, key, placeholderParams || params) : '';

            return res === '' ? fallback(keyset, key, phrase, params, placeholderParams) : res;
        };

    /**
     * Переопределение BEM.I18N.key которое позволяет использовать BEMJSON в параметрах
     * @param {String} keyset
     * @param {String} key
     * @param {String} phrase
     * @param {Object} [params]
     * @returns {String|BEMJSON} Если все параметры - строки, вернется строка, иначе - BEMJSON
     */
    iget2 = function(keyset, key, phrase, params) {
        if (typeof params == 'undefined') {
            return i18nWithFallback(keyset, key, phrase);
        } else {
            var hasNonStringParams = Object.keys(params).some(function(key) {
                return typeof params[key] === 'object';
            });

            if (!hasNonStringParams) {
                return i18nWithFallback(keyset, key, phrase, params);
            } else {
                var placeholderParams = Object.keys(params).reduce(function(prev, param) {
                        prev[param] = placeholder + uniqMarker + param + placeholder;

                        return prev;
                    }, {}),
                    templateString = i18nWithFallback(keyset, key, phrase, params, placeholderParams),
                    splitTemplate = templateString.split(placeholder);

                return splitTemplate.map(function(str) {
                    return params[str.replace(uniqMarker, '')] || str;
                });
            }
        }
    };

    u.register({
        /**
         * Плюрализация, в зависимости от кол-ва подставляем нужную форму
         * none, some, many или phrase
         * @param {String} phrase
         * @param {Object} params
         * @returns {String}
         */
        iget2Pluralize: function(phrase, params) {
            if (params.count === 0) {
                return params.none || params.many;
            }

            params.count %= 100;
            if (params.count >= 5 && params.count <= 20) {
                return params.many;
            }

            params.count %= 10;
            if (params.count === 1) {
                return phrase;
            } else if (params.count < 5 && params.count > 0) {
                return params.some;
            }

            return params.many;
        }

    });
}());
