(function() {
    u.register({
        imageAd: {
            /**
             * Определяет состоит ли группа баннеров только из графических объявлений
             * @param {Object[]} groupBannerTypes коллекция типов баннеров в группе
             * @param {String} groupBannerTypes.banner_type тип баннера
             * @param {Number} groupBannerTypes.count количество баннеров в группе соответсвующего типа
             * @returns {Boolean}
             */
            groupHasOnlyCpcVideoAndImageAds: function(groupBannerTypes) {

                return !u._.filter(groupBannerTypes, function(item) {
                    var bannerType = item.banner_type;

                    return item.banner_type !== 'image_ad' && bannerType !== 'cpc_video' && item.count > 0;
                }).length;
            },

            /**
             * Переопределяет высоту, ширину и коэффициент масштабирования графического объявления
             * для показа форматов, предназначенных для ретины в сжатом виде (DIRECT-56938)
             * @param {Object} imageData данные об изображении
             * @returns {Object}
             */
            fixDimensions: function(imageData) {
                var retinaFormats = [
                        [640, 100],
                        [640, 200],
                        [640, 960],
                        [960, 640]
                    ],
                    isRetinaFormat = retinaFormats.some(function(format) {
                        return format[0] === +imageData.width && format[1] === +imageData.height;
                    }),
                    result = u._.extend({}, imageData);

                if (isRetinaFormat) {
                    result.width = imageData.width / 2;
                    result.height = imageData.height / 2;
                    result.scale = imageData.scale * 2;
                }

                return result;
            },

            /**
             * Преобразует высоту и ширину изображение в строковое представление
             * @param {string|number} width
             * @param {string|number} height
             * @returns {string}
             */
            imageSizeToString: function(width, height) {
                return width + '×' + height;
            },

            /**
             * Возвращает массив размеров изображений по умолчанию
             * @returns {string[]}
             * @private
             */
            getDefaultResolutionsList: function() { // прокинуть константу DIRECT-83834
                return ['240×400', '300×250', '300×500', '300×600', '336×280', '640×100', '640×200', '640×960', '728×90', '960×640', '970×250'];
            }
        }
    });
})();
