(function() {
    u.register({
        'interests-targeting': {
            /**
             * Преобразовывает серверные данные списка всех возможных категорий интересов
             * @param {Array} interestsList серверные данные категорий интересов
             * @returns {Object}
             */
            transformServerData: function(interestsList) {
                var result = {},
                    addItemToTreeList = function(item) {
                        var id = item.target_category_id;

                        if (result[id]) {
                            return;
                        }

                        result[id] = {
                            name: item.name,
                            id: id,
                            orderIndex: item.order_num,
                            available: !!item.available
                        };
                    };

                (interestsList || []).forEach(function(item) {
                    var i = 0,
                        childs = item.childs;

                    addItemToTreeList(item);

                    if (!childs) {
                        return;
                    }

                    while (childs[i]) {
                        addItemToTreeList(childs[i]);

                        result[childs[i].target_category_id].parentId = item.target_category_id;

                        i++;
                    }
                }, this);

                return result;
            },

            /**
             * Формирует путь к указанной категории интересов
             * @param {String} categoryId - ID категории интересов
             * @param {Object} categories - хэш категорий, полученный ин метода transformServerData
             * @param {Number} [skip] - количество элементов, начиная с последнего, которые нужно пропустить
             * @returns {String} - названия категорий, разделенные стрелочкой
             */
            getPath: function(categoryId, categories, skip) {
                var path = [],
                    parentItemId = categoryId,
                    parentItem;

                while (parentItem = categories[parentItemId]) {
                    path.push(parentItem.name);
                    parentItemId = parentItem.parentId;
                }

                return path.slice(skip).reverse().join(' → ');
            }
        }
    });
})();
