block('i-utils').match(function() {
    return this.utilsElem;
}).def()(function() {
    applyNext();

    var log = this.data.log,
        execWithTimeLog = function(func) {
            return function() {
                var timeStart = +new Date(),
                    result,
                    timeTotal = 0;

                for (var i = 0; timeTotal < 10; i++) {
                    result = func.apply(this, arguments);
                    timeTotal = +new Date() - timeStart;
                }

                return {
                    value: result,
                    time: timeTotal,
                    count: i,
                    timeOne: timeTotal / i
                };
            };
        },
        formatExecResult = function(result) {
            return [result.time, result.count, result.timeOne].join('/');
        },
        /**
         * Возвращает функции переданные в параметрах, замеряет время их работы и записывает это время в
         * protected/logs/frontend.<name>.time.<дата> в формате
         * <общее время время выполнения всех итераций>/<количество итераций>/<время выполнения одного запуска>
         * парами <результат для perl функции> - <результат для js функции>
         * Например
         * 2015-11-25      17:40:21        30/155698/0.0001926807023853871 - 30/165145/0.00018165854249296072
         * Означает функции запускались в цикле по 30 миллисекунд, perl вариант выполнился 155698 раз, js вариант - 165145 раз
         *
         * Если функции возвращают разный результат, это будет записано в protected/logs/frontend.<name>.notEqual.<дата>
         * @param {String} name часть названия лога
         * @param {Fuction} perlFunc перловый вариант функции
         * @param {Function} jsFunc js-вариант функции
         * @returns {Function}
         */
        makeCompare = function(name, perlFunc, jsFunc) { // eslint-disable-line no-unused-vars
            return function() {
                var perlResult,
                    jsResult,
                    isEqual;

                perlResult = execWithTimeLog(perlFunc).apply(this, arguments);
                jsResult = execWithTimeLog(jsFunc).apply(this, arguments);

                if (typeof perlResult.value == 'number') {
                    isEqual = Math.abs(perlResult.value - jsResult.value) < 1e-6;
                } else {
                    isEqual = u._.isEqual(perlResult.value, jsResult.value);
                }

                if (!isEqual) {
                    log(
                        name + '.notEqual',
                        JSON.stringify(Array.prototype.slice.call(arguments)) + ': ' + // ignore stringify
                        JSON.stringify(perlResult.value) + ' - ' + JSON.stringify(jsResult.value)); // ignore stringify
                }

                log(name + '.time', formatExecResult(perlResult) + ' - ' + formatExecResult(jsResult));
            };
        };

    // место для переопределения конкретных функций
    // u.currencies.getName = makeCompare('format_currency', this.data.format_currency, u.currencies.getName);
    return '';
});
