(function() {
    // Маппинг измерителей в их названия
    var measurerSystemsNames = {
            admetrica: 'AdMetrica',
            adloox: 'Adloox',
            adriver: 'AdRiver',
            dv: 'DV',
            integral_ad_science: 'Integral Ad Science',
            mediascope: 'Mediascope',
            moat: 'Moat',
            sizmek: 'Sizmek',
            weborama: 'Weborama',
            omi: 'OMI'
        },
        // Измерители с интеграцией (не нужны параметры, изменение возможно только авторизованным в системе)
        measurerSystemsWithIntegration = {
            mediascope: true
        },
        measurerSystemsWithoutParams = {
            mediascope: true,
            adloox: true,
            omi: true,
            moat: true
        },
        requests = {},
        requestsTimers = {};

    u.register({
        measurers: {
            isEnabled: function(model, measurerSystem) {
                var triggerName = u.measurers.getTriggerName(measurerSystem);

                return model[triggerName] || false;
            },

            hasIntegration: function(measurerSystem) {
                return Boolean(measurerSystemsWithIntegration[measurerSystem]);
            },

            withoutParams: function(measurerSystem) {
                return measurerSystemsWithoutParams[measurerSystem];
            },

            getMeasurerSystemName: function(measurerSystem) {
                return measurerSystemsNames[measurerSystem];
            },

            getParams: function(model, measurerSystem) {
                var field = u.measurers.getParamsName(measurerSystem);

                return model[field] || '';
            },

            getTriggerName: function(measurerSystem) {
                return ['measurer_', '_enabled'].join(measurerSystem);
            },

            getParamsName: function(measurerSystem) {
                return ['measurer_', '_params'].join(measurerSystem);
            },

            getMeasurerSystems: function() {
                // Список измерителей в том порядке, в котором они выводятся в интерфейсе
                return [
                    'admetrica',
                    'adriver',
                    'dv',
                    'integral_ad_science',
                    'sizmek',
                    'weborama',
                    'mediascope',
                    'adloox',
                    'moat',
                    'omi'
                ];
            },

            getModelFields: function(rightsFilter) {
                return u.measurers.getMeasurerSystems().reduce(function(acc, measurerSystem) {
                    if (rightsFilter && !rightsFilter(measurerSystem)) {
                        return acc;
                    }

                    acc.push(u.measurers.getTriggerName(measurerSystem));
                    acc.push(u.measurers.getParamsName(measurerSystem));

                    return acc;
                }, [])
            },

            prepareDataFromModel: function(data, model, measurer) {
                var triggerName = u.measurers.getTriggerName(measurer.measurer_system),
                    paramsName = u.measurers.getParamsName(measurer.measurer_system);

                if (model[triggerName] !== undefined) {
                    data[triggerName] = model[triggerName];
                    data[paramsName] = model[paramsName];
                }

                return data;
            },

            applyEnabledModelData: function(model, measurer) {
                var triggerName = u.measurers.getTriggerName(measurer.measurer_system),
                    paramsName = u.measurers.getParamsName(measurer.measurer_system);

                model[triggerName] = true;
                model[paramsName] = measurer.params;

                return model
            },

            provideModelData: function(model, rights) {
                if (!rights) {
                    return [];
                }

                return u.measurers.getMeasurerSystems().reduce(function(acc, system) {
                    var triggerName = u.measurers.getTriggerName(system),
                        paramsName = u.measurers.getParamsName(system),
                        measurerFlag = model[triggerName],
                        measurerParams = model[paramsName];

                    if (system && rights[system] && measurerFlag) {
                        acc.push({
                            measurer_system: system,
                            params: measurerParams || '{}',
                            has_integration: u.measurers.hasIntegration(system)
                        });
                    }

                    return acc;
                }, []);
            },

            getAuthorizedSystems: function(ulogin, clientId) {
                var key = ulogin + clientId;

                if (requests[key]) {
                    return requests[key];
                } else {
                    var onResult = function() {
                        requestsTimers[key] = setTimeout(function() {
                            requests[key] = null;
                        }, 1000);
                    };

                    return requests[key] = BEM.blocks['i-web-api-request'].measurers.getAuthorizedList(ulogin, clientId)
                        .then(function(response) {
                            onResult();
                            return Promise.resolve(response.result);
                        }, function(error) {
                            onResult();
                            return Promise.reject(error);
                        });
                }
            }
        }
    });
})();
