(function() {
    /**
     * Возвращает ссылку на метрику в зависимости от домена
     * @param {String} path
     * @returns {String}
     */
    var getMetrikaUrl = function(path) {
        return u.formatUrl({
            protocol: 'https',
            host: 'metrika.yandex.' + u.consts('tld'),
            path: path
        });
    };

    u.register({
        getMetrikaUrl: getMetrikaUrl,
        getMetrikaPreloadScript: function(isWebvisorEnabled) {
            return [
                u.hasClientFeature('metrika_preload_in_head') && {
                    tag: 'link',
                    attrs: {
                        rel: 'preload',
                        as: 'script',
                        href: isWebvisorEnabled ?
                            'https://mc.yandex.ru/metrika/tag.js' :
                            'https://mc.yandex.ru/metrika/tag_turbo.js'
                    }
                },
            ].filter(Boolean);
        },
        getMetrikaScript: function(isWebvisorEnabled, csp_nonce) {
            return [
                u.hasClientFeature('metrika_load_in_head') && {
                    tag: 'script',
                    attrs: {
                        nonce: csp_nonce
                    },
                    content: [
                        '!function(e,n,t,a,c){e.ym=e.ym||function(){(e.ym.a=e.ym.a||[]).push(arguments)},',
                        'e.ym.l=+new Date,a=n.createElement(t),c=n.getElementsByTagName(t)[0],a.async=1,',
                        'a.src="https://mc.yandex.ru/metrika/',
                        isWebvisorEnabled ? 'tag.js' : 'tag_turbo.js',
                        '",',
                        'a.crossOrigin="anonymous",c.parentNode.insertBefore(a,c)}(window,document,"script"),',
                        'ym(34,"init",{clickmap:!0,trackLinks:!0,accurateTrackBounce:!0,triggerEvent:!0});',
                    ].join('')
                },
            ].filter(Boolean);
        },
    });
}());
