describe('i-utils__minus-words', function() {
    var mw = u.minusWords;

    describe('.stringToArray()', function() {

        it('Должен разбить строку по знаку « -» на массив фраз', function() {
            expect(mw.stringToArray('word -word word')).to.be.eql(['word', 'word word']);
        });

        it('Должен разбить строку по знаку «- » на массив фраз', function() {
            expect(mw.stringToArray('word - word word')).to.be.eql(['word', 'word word']);
        });

        it('Должен разбить строку по знаку «,» на массив фраз', function() {
            expect(mw.stringToArray('word,word word')).to.be.eql(['word', 'word word']);
        });

        it('Должен разбить строку по знаку «\r» на массив фраз', function() {
            expect(mw.stringToArray('word' + "\r" +'word word')).to.be.eql(['word', 'word word']);
        });

        it('Должен разбить строку по знаку «\n» на массив фраз', function() {
            expect(mw.stringToArray('word' + "\n" +'word word')).to.be.eql(['word', 'word word']);
        });

        it('Должен разбить строку по знаку «\t» на массив фраз', function() {
            expect(mw.stringToArray('word' + "\t" +'word word')).to.be.eql(['word', 'word word']);
        });

        it('Должен удалить лишние пробелы вокруг минус фраз', function() {
            expect(mw.stringToArray('  word  - word  word  - ')).to.be.eql(['word', 'word word']);
        });

        [
            '!',
            '+'
        ].forEach(function(char) {
            it('Справа от «' + char + '» не должно быть пробелов', function() {
                expect(mw.stringToArray('word  ' + char + '    word  word')[0]).to.be.eql('word ' + char + 'word word');
            });

        });

        it('Удаляем лишние «-» в конце фразы', function() {
            expect(mw.stringToArray('word---,---word')).to.be.eql(['word', 'word']);
        });

        it('Удаляем лишние пробелы между «[]»', function() {
            expect(mw.stringToArray('[word word   ] word')[0]).to.be.eql('[word word] word');
        });

        it('Должен разбить строку на массив', function() {
            expect(mw.stringToArray('-приставка-корень-суффикс-окончание -a -b -d-'))
                .to.be.eql(['приставка-корень-суффикс-окончание', 'a', 'b', 'd']);
        });

        it('Должен вернуть тот же массив если в качестве аргумента пришел массив', function() {
            var arr = ['-a', '-b', '-d'];

            expect(mw.stringToArray(arr)).to.be.equal(arr);
        });

    });
    
    describe('.arrayToString()', function() {
        it('Должен принять коллекцию минус-слов как массив а вернуть как строку', function() {
            expect(mw.arrayToString(['a', '-b', 2, null, undefined])).to.be.eql('-a -b -2');
        });
    });

    describe('.isEmpty()', function() {
        it('Массив без символов должен признаваться пустым набором минус-слов', function() {
            expect(mw.isEmpty([])).to.be.true;
            expect(mw.isEmpty(['', ' '])).to.be.true;
        });
        it('Строка без символов должна признаваться пустым набором минус-слов', function() {
            expect(mw.isEmpty('')).to.be.true;
            expect(mw.isEmpty(' ')).to.be.true;
        });
        it('Строка с символами должна признаваться набором минус-слов', function() {
            expect(mw.isEmpty('-word')).to.be.false;
        });
        it('Массив с символами должен признаваться набором минус-слов', function() {
            expect(mw.isEmpty(['','-word'])).to.be.false;
        });
    });

});
