(function() {

    u.register({
        minusWords: {

            /**
             * Приводит переданную строку к валидному массиву минус-слов/фраз
             * @param {String} str - Строка из минус-слов/фраз
             * @return {Array}
             * @private
             */
            _parseString: function(str) {
                var minusPhrases,
                    toArrayRexExp = this.phrasesToArrayRexExp;

                minusPhrases = str
                    .replace(toArrayRexExp, ',')
                    .split(/,+/g)
                    .reduce(function(result, minusPhrase) {
                        minusPhrase = minusPhrase.trim();

                        if (minusPhrase) {
                            minusPhrase = minusPhrase
                                // заменяем пробелы одним
                                .replace(/(\s+)/g, ' ')

                                // удаляем ---
                                .replace(/(-+)/g, '-')

                                // убираем пробелы справа от !, +
                                .replace(/(!|\+)\s+/g, function(match) {
                                    match = match.replace(/\s/g, '');

                                    return match;
                                })

                                // удаляем - в начале, в конце фразы
                                .replace(/(^-|-$)/g, '')

                                // убираем лишние пробелы между []
                                .replace(/\[(\s*.+\s*)\]/g, function(match, l) {
                                    return '[' + l.trim() + ']';
                                })

                                // убираем лишние пробелы с двух сторон от "
                                .replace(/\s*"\s*/g, '"')

                                .trim();

                            result.push(minusPhrase);
                        }

                        return result;
                    }, []);

                return minusPhrases;
            },

            /**
             * Регулярное выражение по правилам которого строка минус-фраз разбивается на массив
             * */
            phrasesToArrayRexExp: /((^|\s)-+|-\s|,|\n|\r|\t)/g,

            /**
             * Переводит строку минус-слов/фраз в массив.
             * Если Передать массив, вернет тот же массив без изменений
             * @param {String|Array} value - набор минус слов
             * @return {Array}
             * */
            stringToArray: function(value) {
                if (Array.isArray(value)) return value;
                if (value === undefined) return value;

                return this._parseString(value); // разбивает строку на массив
            },

            /**
             * Переводит массив минус-слов/фраз в строку.
             * Если передать строку, вернет ту же строку без изменений
             * @param {Array} value - массив минус-слов
             * @return {String}
             * */
            arrayToString: function(value) {
                if (typeof value == 'string') return value;
                if (value === undefined) return value;

                var minusWords = this._parseString(value.join(' -'));

                return minusWords.length ? '-' + minusWords.join(' -') : '';
            },

            /**
             * Прогоняет фильтр, проверяет является ли переданное значение пустым
             * @param {Array|String} value
             * @return {Boolean}
             * */
            isEmpty: function(value) {
                return !this._parseString([].concat(value).join('')).length;
            },

            /**
             * Приводит строку минус фраз к валидному значению которое будет задаваться в мастере отчетов
             * https://st.yandex-team.ru/DIRECT-63381#1488371934000
             * @param {String} minusPhrases - минус фраза
             * @return {String}
             */
            preprocessingStatPhrases: function(minusPhrases) {
                var result = $.trim(minusPhrases)
                    // заменяем апострофы на пробелы (только апострофы, не одинарные кавычки)
                    .replace(/`/g, ' ')
                    // избавлемся от идущих подряд нескольких точек, которые заменяются на пробел
                    .replace(/\.\.+/g, ' ');

                result = result
                    .split(/\s+/g)
                    .map(function(minusWord) {
                        // если слово содержит точку и не является числом с плавающей точкой
                        if (/\./.test(minusWord) && !/^[0-9]+\.[0-9]+$/.test(minusWord)) {
                            return minusWord.replace(/\./g, ' ');
                        }

                        return minusWord;
                    })
                    .join(' ');

                return result;
            },

            /**
             * Оборачивает строку в кавычки, если их нету
             * @param {String} minusPhrase - минус фраза
             * @returns {String}
             */
            wrapInQuotes: function(minusPhrase) {
                return /^".*"$/.test(minusPhrase) ? minusPhrase : '"' + minusPhrase + '"';
            }

        }
    });

})();
