describe('i-utils__mobile-content', function() {

    describe('isEqualTrackerHref - проверка трекинговых ссылок на идентичность', function() {

        it('Две ссылки должны быть равны', function() {
            var url1 = 'http://1wb-1.tlnk.io/serve',
                url2 = 'http://1wb-1.tlnk.io/serve';
            expect(u.isEqualTrackerHref(url1, url2)).to.be.true;
        });

        it('Пустая строка не равна ссылке', function() {
            var url1 = '',
                url2 = 'http://1wb-1.tlnk.io/serve';
            expect(u.isEqualTrackerHref(url1, url2)).to.be.false;
        });

        it('Пустая строки не равны', function() {
            var url1 = '',
                url2 = '';
            expect(u.isEqualTrackerHref(url1, url2)).to.be.true;
        });

        it('Ссылки не равны по протоколу', function() {
            var url1 = 'https://1wb-1.tlnk.io/serve',
                url2 = 'http://1wb-1.tlnk.io/serve';
            expect(u.isEqualTrackerHref(url1, url2)).to.be.false;
        });

        it('Ссылки не равны по домену', function() {
            var url1 = 'http://1wb-1.tlnk.com/serve',
                url2 = 'http://1wb-1.tlnk.io/serve';
            expect(u.isEqualTrackerHref(url1, url2)).to.be.false;
        });

        it('Ссылки не равны по пути', function() {
            var url1 = 'http://1wb-1.tlnk.com/serve',
                url2 = 'http://1wb-1.tlnk.io/path';
            expect(u.isEqualTrackerHref(url1, url2)).to.be.false;
        });

        it('Ссылки равны по базовым параметрам запроса', function() {
            var url1 = 'http://1wb-1.tlnk.io/serve?action=click',
                url2 = 'http://1wb-1.tlnk.io/serve?action=click';
            expect(u.isEqualTrackerHref(url1, url2)).to.be.true;
        });

    });
});
