(function() {
    u.register(/** @namespace u */ {

        /**
         * Сравнение двух трекинговых ссылок
         * @param {String} user — введенная пользователем ссылка на трекинговую систему
         * @param {String} tracker — эталон, трекинговая ссылка из магазина
         * @returns {Boolean}
         */
        isEqualTrackerHref: function(user, tracker) {
            var diffParams = u._.keys(u.getDiffQueryParams(user, tracker)),
                filterTracker = u._.pick(u.parseUrl(tracker), ['protocol', 'host', 'path', 'hash', 'port', 'query']),
                filterUser = u._.pick(u.parseUrl(user), ['protocol', 'host', 'path', 'hash', 'port', 'query']);

            if (diffParams && diffParams.length) {
                filterUser.query = u._.omit(filterUser.query, diffParams);
            }

            return u._.isEqual(filterUser, filterTracker);
        },

        /**
         * Определяет можно ли редактировать трекинговую ссылку
         * @param {String} user — введенная пользователем ссылка на трекинговую систему
         * @param {String} tracker — эталон, трекинговая ссылка из магазина
         * @returns {Boolean}
         */
        isEditableTrackerHref: function(user, tracker) {
            return tracker ? !u.isEqualTrackerHref(user, tracker) : true;
        }

    });
}());
