(function() {
    var MODERATION_PATH = 'https://modadvert.yandex-team.ru',
        MODERATION_TEST_PATH = 'https://modadvert-test.yandex-team.ru';

    function getModerationHost(isProduction) {
        return isProduction ? MODERATION_PATH : MODERATION_TEST_PATH;
    }

    u.register({
        moderation: {
            getCampaignModerationUrl: function(isProduction, cid) {
                return u.formatUrl({
                    host: getModerationHost(isProduction),
                    path: 'service/direct/search',
                    query: {
                        autoEditSelect: false,
                        pageNum: 1,
                        pageSize: 50,
                        q: JSON.stringify({
                            type: ['banner', 'image_ad_sm','canvas_sm','html5_sm','cpm_video','cpm_yndx_frontpage','fixcpm_yndx_frontpage','canvas','html5','text_sm'],
                            related_objects: {
                                types: []
                            },
                            campaign_id: [cid]
                        }),
                        viewMode: 'compact'
                    }
                }, true)
            },
            getCampaignDocumentsUrl: function(isProduction, clientId) {
                return u.formatUrl({
                    host: getModerationHost(isProduction),
                    path: 'new/direct/documents',
                    query: {
                        'client_id[]': clientId,
                    }
                })
            }
        }
    });
})();
