describe('i-utils__normalize', function() {
    describe('beminize', function() {
        it('Должен заменять "_" на "-"', function() {
            expect(u.beminize('mail_agent')).to.be.equal('mail-agent');
        });

        it('Должен преобразовывать CamelCaseWithCAPSEDtextANDinTheEND в нижний регистр с разделителем "-"', function() {
            expect(u.beminize('CamelCaseWithCAPSEDtextANDinTheEND')).to.be.equal('camel-case-with-capsed-text-and-in-the-end');
        });

        it('Должен преобразовывать mixed_Values_WithCamels в нижний регистр с разделителем "-"', function() {
            expect(u.beminize('mixed_Values_WithCamels')).to.be.equal('mixed-values-with-camels');
        });

        it('Должен преобразовывать Extra----Dashes--here в нижний регистр не изменяя ничего остального', function() {
            expect(u.beminize('Extra----Dashes--here')).to.be.equal('Extra----Dashes--here'.toLowerCase());
        });

        it('Должен преобразовывать SinglE-DASHES-here в нижний регистр с разделителем "-"', function() {
            expect(u.beminize('SinglE-DASHES-here')).to.be.equal('singl-e-dashes-here');
        });
    });
});
