describe('i-utils__officeCity', function() {
    describe('getOfficeCityFromData', function() {
        var sandbox,
            constStub;

        beforeEach(function() {
            sandbox = sinon.sandbox.create();
            constStub = sandbox.stub(u, 'consts');
        });

        afterEach(function() {
            sandbox.restore();
        });

        describe('Должен возвращать белорусский офис (blr)', function() {
            it('Если находимся на морде или клиент без страны, и на домене .by', function() {
                constStub.withArgs('domains').returns({'by': 1}).withArgs('client_country').returns(undefined);
                var data = {index_page: 1};

                expect(u.getOfficeCityFromData(data)).to.be.equal('blr');
            });

            it('Если клиент из Белоруссии (client-country = 149)', function() {
                constStub.withArgs('domains').returns({}).withArgs('client_country').returns('149');

                expect(u.getOfficeCityFromData({})).to.be.equal('blr');
            });
        });

        describe('Должен возвращать украинский офис (ukr)', function() {
            it('Если находимся на домене .ua', function() {
                constStub.withArgs('domains').returns({'ua': 1}).withArgs('client_country').returns(undefined);

                expect(u.getOfficeCityFromData({})).to.be.equal('ukr');
            });
        });

        describe('Должен возвращать казахский офис (kaz)', function() {
            it('Если находимся на домене .kz', function() {
                constStub.withArgs('domains').returns({'kz': 1}).withArgs('client_country').returns(undefined);

                expect(u.getOfficeCityFromData({})).to.be.equal('kaz');
            });

            it('Если клиент из Казахстана (client-country = 159)', function() {
                constStub.withArgs('domains').returns({}).withArgs('client_country').returns('159');

                expect(u.getOfficeCityFromData({})).to.be.equal('kaz');
            });

            it('Если клиент из другой страны, но домен .kz', function() {
                constStub.withArgs('domains').returns({'kz': 1}).withArgs('client_country').returns('149');

                expect(u.getOfficeCityFromData({})).to.be.equal('kaz');
            });
        });

        describe('Должен возвращать офис Москвы (msk)', function() {
            it('Если клиент находится в Москве', function() {
                constStub.withArgs('domains').returns({}).withArgs('client_country').returns(undefined);
                var data = {officecity: 'msk'};
                expect(u.getOfficeCityFromData(data)).to.be.equal('msk');
            });
        });

        describe('Должен возвращать дефолтный офис (other)', function() {
            it('Если никакой другой информации', function() {
                constStub.withArgs('domains').returns({}).withArgs('client_country').returns(undefined);

                expect(u.getOfficeCityFromData({})).to.be.equal('other');
            });
        });
    });
});
