u.register({
    getOfficeCityFromData: function(data) {
        // если у клиента нет страны, то поле client_country на разных страницах стоит или null или '0'
        var isNotClientCountry = u.consts('client_country') === null || u.consts('client_country') == '0',
            isKazClient = u.consts('domains')['kz'] || u.consts('client_country') == '159',
            isBelarusClient = ((data.index_page == 1 || isNotClientCountry) ?
                u.consts('domains')['by'] :
                u.consts('client_country') == '149'),
            isUkrClient = u.consts('domains')['ua'],
            officeCity;

        if (isUkrClient) {
            officeCity = 'ukr';
        }

        if (isBelarusClient) {
            officeCity = 'blr';
        }

        if (isKazClient) {
            officeCity = 'kaz';
        }

        if (!officeCity) {
            officeCity = data.office_city || data.officecity || 'other';
        }

        return officeCity;
    }
});
