describe('i-utils__old-browsers', function() {
    var testCases = [
        {
            name: 'Возвращает isBrowserUnsupported: false, если название браузера отсутствует',
            uatraits: { BrowserVersion: '42' },
            expectedResult: { isYandexBrowser: false, isBrowserUnsupported: false }
        },
        {
            name: 'Возвращает isBrowserUnsupported: true, если версия браузера отсутствует',
            uatraits: { BrowserName: 'Chrome' },
            expectedResult: { isYandexBrowser: false, isBrowserUnsupported: true }
        },
        {
            name: 'Возвращает isBrowserUnsupported: false, если это hermione-тесты',
            uatraits: { BrowserName: 'Chrome', BrowserVersion: '1' },
            options: { isHermione: true },
            expectedResult: { isYandexBrowser: false, isBrowserUnsupported: false }
        },
        {
            name: 'Возвращает isYandexBrowser: true, если это Yandex Browser',
            uatraits: { BrowserName: 'YandexBrowser', BrowserVersion: '777' },
            expectedResult: { isYandexBrowser: true, isBrowserUnsupported: false }
        },
        {
            name: 'Возвращает isBrowserUnsupported: true, если мажорная версия браузера меньше минимальной',
            uatraits: { BrowserName: 'Chrome', BrowserVersion: '40' },
            expectedResult: { isYandexBrowser: false, isBrowserUnsupported: true }
        },
        {
            name: 'Возвращает isBrowserUnsupported: false, если мажорная версия браузера больше минимальной',
            uatraits: { BrowserName: 'Chrome', BrowserVersion: '777' },
            expectedResult: { isYandexBrowser: false, isBrowserUnsupported: false }
        },
        {
            name: 'Возвращает isBrowserUnsupported: true, если минорная версия браузера меньше минимальной',
            uatraits: { BrowserName: 'Safari', BrowserVersion: '13.0' },
            expectedResult: { isYandexBrowser: false, isBrowserUnsupported: true }
        },
        {
            name: 'Возвращает isBrowserUnsupported: false, если минорная версия браузера равна минимальной',
            uatraits: { BrowserName: 'Safari', BrowserVersion: '13.1' },
            expectedResult: { isYandexBrowser: false, isBrowserUnsupported: false }
        },
        {
            name: 'Возвращает isBrowserUnsupported: false, если минорная версия браузера больше минимальной',
            uatraits: { BrowserName: 'Safari', BrowserVersion: '13.2' },
            expectedResult: { isYandexBrowser: false, isBrowserUnsupported: false }
        },
        {
            name: 'Возвращает isBrowserUnsupported: true, если нет минорной версии браузера',
            uatraits: { BrowserName: 'Safari', BrowserVersion: '13' },
            expectedResult: { isYandexBrowser: false, isBrowserUnsupported: true }
        },
    ];

    testCases.forEach(function(testCase) {
        it(testCase.name, function() {
            expect(
                u.getIsBrowserUnsupported(testCase.uatraits, testCase.options || {})
            ).to.be.deep.equal(testCase.expectedResult);
        });
    });
});
