(function() {
    function isLess(versionA, versionB) {
        var partsA = versionA.split('.'),
            partsB = versionB.split('.');

        for (var index = 0; index < partsB.length; index++) {
            var partA = Number(partsA[index]) || 0,
                partB = Number(partsB[index]) || 0;

            if (partA > partB) {
                return false;
            }

            if (partA < partB) {
                return true;
            }
        }

        return false;
    }

    var getIsBrowserUnsupported = function(uatraits, options) {
        var ALL_UNSUPPORTED = '100000',
            // если подменить user-agent на агент от Оперы Мини,
            // не приходит BrowserVersion
            browserName = uatraits && uatraits.BrowserName || 'noname',
            browserVersion = uatraits && uatraits.BrowserVersion || '0',
            isHermione = options.isHermione,
            supportedBrowsers = {
                YandexBrowser: '20',
                Firefox: '78',
                Chrome: '85',
                Opera: '72',
                Safari: '13.1',
                MSIE: ALL_UNSUPPORTED,
                Edge: '87'

                // https://st.yandex-team.ru/DIRECT-116045#5e78f241e27a4529bf2b088d
                // MobileSafari: '12',
                // AndroidBrowser: ALL_UNSUPPORTED,
                // OperaMobile: ALL_UNSUPPORTED,
                // OperaMini: ALL_UNSUPPORTED,
                // MobileFirefox: ALL_UNSUPPORTED,
                // ChromeMobile: '78'
            };

        return {
            isYandexBrowser: browserName == 'YandexBrowser',
            isBrowserUnsupported: !isHermione &&
                !!supportedBrowsers[browserName] &&
                isLess(browserVersion, supportedBrowsers[browserName])
        }
    };

    u.register({
        getIsBrowserUnsupported: getIsBrowserUnsupported
    });
}());
