u.register({
    payment: {
        setOfferAccepted: function() {
            if (!u.consts('isModerationsOfferFeatureEnabled')) {
                return true;
            }

            var deferred = $.Deferred(),
                url = '/web-api/user/set_offer_accepted';

            if (u.consts('ulogin')) {
                url += '?ulogin=' + u.consts('ulogin');
            }

            var requestInstance = BEM.create('i-request_type_ajax', {
                url: url,
                type: 'POST',
                cache: false,
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': u.consts('csrf_token'),
                    'X-Detected-Locale': u.consts('lang')
                },
                contentType: 'application/json; charset=utf-8',
                paramsToSettings: ['contentType', 'headers'],
                timeout: 1200000,
                callbackCtx: this
            });

            requestInstance.get(
                {},
                function(result) {
                    deferred.resolve(result);
                },
                function(error) {
                    deferred.reject(error)
                }
            );

            return deferred.promise();
        }
    }
});
