describe('i-utils__phrase-formatter', function() {
    var formatter;

    beforeEach(function() {
        formatter = u.phraseFormatter;
    });

    describe('#getKeyWords', function() {
        it('Ключевик без минус слова "test phrase"', function() {
            expect(formatter.getKeyWords('test phrase')).to.be.equal('test phrase');
        });

        it('Ключевик с минус словами "test phrase -bla bla"', function() {
            expect(formatter.getKeyWords('test phrase -bla bla')).to.be.equal('test phrase');
        });

        it('Ключевик с минус словами "test phrase -bla -bla"', function() {
            expect(formatter.getKeyWords('test phrase -bla -bla')).to.be.equal('test phrase');
        });

        it('Ключевик с дефисом "test-phrase"', function() {
            expect(formatter.getKeyWords('test-phrase')).to.be.equal('test-phrase');
        });

        it('Минус слова без ключевика "-bla bla"', function() {
            expect(formatter.getKeyWords('-bla bla')).to.be.equal('');
        });
    });

    describe('#getMinusWords', function() {
        it('Ключевик без минус слова "test phrase"', function() {
            expect(formatter.getMinusWords('test phrase')).to.be.eql([]);
        });

        it('Ключевик с минус словами "test phrase -bla bla"', function() {
            expect(formatter.getMinusWords('test phrase -bla bla')).to.be.eql(['bla', 'bla']);
        });

        it('Ключевик с минус словами "test phrase -bla -bla"', function() {
            expect(formatter.getMinusWords('test phrase -bla -bla')).to.be.eql(['bla', 'bla']);
        });

        it('Ключевик с дефисом "test-phrase"', function() {
            expect(formatter.getMinusWords('test-phrase')).to.be.eql([]);
        });

        it('Минус слова с дефисом "test phrase -bla-bla"', function() {
            expect(formatter.getMinusWords('test phrase -bla-bla bla')).to.be.eql(['bla-bla', 'bla']);
        });

        it('Минус слова без ключевика "-bla bla"', function() {
            expect(formatter.getMinusWords('-bla bla')).to.be.eql(['bla', 'bla']);
        });
    });

    describe('#getFixOff', function() {
        it('Ключевик i+phone bla, fixation = [["i+phone", "i phone"]]', function() {
            expect(formatter.getFixOff([['i+phone', 'i phone']], 'i+phone bla')).to.be.equal('i phone bla');
        });

        it('Ключевик i+phone bla i+pad, fixation = [["i+phone", "i phone"], ["i+pad", "i pad"]]', function() {
            expect(formatter.getFixOff([['i+phone', 'i phone'], ['i+pad', 'i pad']], 'i+phone bla i+pad')).to.be.equal('i phone bla i pad');
        });
    });
});
