u.register({
    phraseFormatter: {
        excludeAutotargeting: function(phrase) {
            return phrase.replace(/^\s*---autotargeting\s+/, '');
        },

        getKeyWords: function(phrase) {
            var phraseWithoutAutotargeting = this.excludeAutotargeting(phrase),
                hasAutotargeting = phraseWithoutAutotargeting !== phrase,
                keywords = (phraseWithoutAutotargeting + '').split(/^-|\s-/).shift();

            return hasAutotargeting ? '---autotargeting ' + keywords : keywords;
        },

        /**
         * Возвращает массив минус-слов
         * @param {String} phrase
         * @returns {Array}
         */
        getMinusWords: function(phrase) {
            var phraseWithoutAutotargeting = this.excludeAutotargeting(phrase),
                res = (phraseWithoutAutotargeting + '').split(/^-|\s-/);

            res.shift();

            res = res.join(' ');

            return u.minusWords.stringToArray(res.split(/\s+/).join(' -'));
        },

        getFixOff: function(fixation, keyWords) {
            var res = keyWords;

            fixation.forEach(function(fix) {
                res = res.replace(fix[0], fix[1]);
            });

            return res;
        }
    }
});
