describe('i-utils__phrase', function() {
    describe('textToDetailHash', function() {
        [
            {
                input: 'qwe rty',
                output: { phrase_plus: 'qwe rty', minus_words: [] },
                description: 'фраза без минус-слов'
            },
            {
                input: 'qwe rty -asd -fgh',
                output: { phrase_plus: 'qwe rty', minus_words: ['asd', 'fgh'] },
                description: 'фраза с минус-словаим'
            },
            {
                input: 'qwe !rty +uio -!asd -+fgh -jkl',
                output: { phrase_plus: 'qwe !rty +uio', minus_words: ['!asd', '+fgh', 'jkl'] },
                description: 'сложная фраза'
            }
        ].forEach(function(test) {
            it (test.description, function() {
                expect(u.phrase.textToDetailHash(test.input)).to.be.eql(test.output);
            })
        })
    })
});
