u.register({
    phrase: {
        /**
         * Разбирает фразу во фразу с плюс-словами и минус слова
         * @see PhraseText::phrase_text2detail_hash
         * @param {String} text
         * @returns {{phrase_plus: String, minus_words: String[]}}
         */
        textToDetailHash: function(text) {
            var parts = text.match(/^(.*?)(?: (-.*))?$/);

            return {
                phrase_plus: parts[1],
                minus_words: parts[2] ?
                    parts[2].split(' ').map(function(part) {
                        return part.replace(/^-/g, '');
                    }) :
                    []
            };
        }
    }
});
