describe('i-utils__pluralize:', function() {
    var sandbox,
        constStub;

    beforeEach(function() {
        sandbox = sinon.sandbox.create();
        constStub = sandbox.stub(u, 'consts');
    });

    afterEach(function() {
        sandbox.restore();
    });


    describe('pluralizeWord:', function() {

        var pluralizeWord = u.pluralizeWord;

        // single form
        ['ru', 'ua', 'en', 'tr'].forEach(function(lang) {
            it('должна использоваться форма 1 в единственном числе для языка "' + lang + '"', function() {
                constStub.withArgs('lang').returns(lang);
                expect(pluralizeWord(['1', '2', '3'], 1)).to.equal('1');
            });
        });

        // plural form (2)
        ['ru', 'ua', 'en', 'tr'].forEach(function(lang) {
            it('должна использоваться форма 2 во множественном числе (2) для языка "' + lang + '"', function() {
                constStub.withArgs('lang').returns(lang);
                expect(pluralizeWord(['1', '2', '3'], 2)).to.equal('2');
            });

            it('должна использоваться форма 2 во множественном числе (22) для языка "' + lang + '"', function() {
                constStub.withArgs('lang').returns(lang);
                expect(pluralizeWord(['1', '2', '3'], 22)).to.equal('2');
            });
        });

        // plural form (5)
        [0, 5, 10, 11, 12, 15, 20, 25].forEach(function(count) {
            it('должна использоваться форма 3 во множественном числе (' + count + ') для языка "ru"', function() {
                constStub.withArgs('lang').returns('ru');
                expect(pluralizeWord(['1', '2', '3'], count)).to.equal('3');
            });

            it('должна использоваться форма 3 во множественном числе (' + count + ') для языка "ua"', function() {
                constStub.withArgs('lang').returns('ua');
                expect(pluralizeWord(['1', '2', '3'], count)).to.equal('3');
            });

            it('должна использоваться форма 2 во множественном числе (' + count + ') для языка "en"', function() {
                constStub.withArgs('lang').returns('en');
                expect(pluralizeWord(['1', '2', '3'], count)).to.equal('2');
            });

            it('должна использоваться форма 2 во множественном числе (' + count + ') для языка "tr"', function() {
                constStub.withArgs('lang').returns('tr');
                expect(pluralizeWord(['1', '2', '3'], count)).to.equal('2');
            });
        });

        // plural form (21)
        ['ru', 'ua'].forEach(function(lang) {
            it('должна использоваться форма 1 во множественном числе (21) для языка "' + lang + '"', function() {
                constStub.withArgs('lang').returns(lang);
                expect(pluralizeWord(['1', '2', '3'], 21)).to.equal('1');
            });
        });

        ['en', 'tr'].forEach(function(lang) {
            it('должна использоваться форма 2 во множественном числе (21) для языка "' + lang + '"', function() {
                constStub.withArgs('lang').returns(lang);
                expect(pluralizeWord(['1', '2', '3'], 21)).to.equal('2');
            });
        });
    });

    describe('pluralize:', function() {

        var pluralize = u.pluralize;

        beforeEach(function () {
            sandbox.stub(u, 'pluralizeWord').returns('plural form');
        });

        it('должен использоваться формат: {count}{separator}{unit name}', function() {
            expect(pluralize('', 5, '-')).to.equal('5-plural form');
        });

        it('должен использоваться разделитель по умолчанию - пробел ', function() {
            expect(pluralize('', 5)).to.equal('5 plural form');
        });
    });

    describe('pluralForms:', function() {

        it('в шаблон должны подставляться корректные формы слов', function() {
            expect(u.pluralForms('{1|2|3}{4|5|6}{7|8|9}', 1, 2, 5)).to.equal('159');
        });

        it('должен воспринимать массив с BEMJSON внутри', function() {
            expect(u.pluralForms(['Существует ', '{1|2|3}', ' типа людей'], 2)).to.eql(['Существует ', '2', ' типа людей']);
        });
    });
});
