(function() {
    u.register({

        /**
         * Определение id ссылки для модального окна в зависимости от типа группы
         * @param {Object} params - критерии для подбора текста
         * @param {String} params.groupType - тип группы объявлений
         */
        getRarelyServedHelpId: function(params) {
            var helpUrlId;

            switch (params.groupType) {
                case 'dynamic': // Динамические
                    helpUrlId = 'rarely-served-dynamic-text-ads';
                    break;
                case 'performance': // Смарт
                    helpUrlId = 'rarely-served-smart-banners';
                    break;
                default: // ТГО+РМП
                    helpUrlId = 'rarely-served-text-ads';
            }

            return helpUrlId;
        },

        /**
         * Определение текста для тултипов в условиях показа
         * @param {Object} params - критерии для подбора текста
         * @param {String} params.groupType - тип группы объявлений
         * @param {String} params.phraseType - тип фразы ('phrases' | 'retargetings' | 'interests')
         * @param {Boolean} params.isFilter - флаг фильтра
         */
        getRarelyServedTooltipText: function(params) {
            var helpText = iget2(
                'i-utils',
                'vystavlennye-nastroyki-rabotayut-neeffektivno',
                'Выставленные настройки работают неэффективно. Попробуйте заменить ключевые фразы, поработать над текстом объявления, изменить условия таргетинга и т.д.'
            ); // универсальный текст, на всякий случай

            switch (params.groupType) {
                case 'dynamic': // Динамические
                    helpText = iget2(
                        'i-utils',
                        'uslovie-nacelivaniya-slishkom-uzkoe',
                        'Условие нацеливания слишком узкое. Возможно, на сайте мало товаров, которые подходят под условие нацеливания.'
                    );
                    params.isFilter && (helpText = iget2(
                        'i-utils',
                        'filtr-nastroen-slishkom-uzko',
                        'Фильтр настроен слишком узко. Возможно, в фиде мало товаров, которые подходят под условия фильтрации.'
                    ));
                    break;
                case 'performance': // Смарт
                    params.isFilter && (helpText = iget2(
                        'i-utils',
                        'filtr-nastroen-slishkom-uzko',
                        'Фильтр настроен слишком узко. Возможно, в фиде мало товаров, которые подходят под условия фильтрации.'
                    ));
                    break;
                case 'mcbanner': // ГО на поиске
                    params.phraseType == 'phrases' && (helpText = iget2(
                        'i-utils',
                        'fraza-ochen-redko-ispolzuetsya',
                        'Фраза очень редко используется в поисковых запросах, попробуйте изменить её.'
                    ));
                    break;
                default: // ТГО+РМП
                    params.phraseType == 'phrases' && (helpText = iget2('i-utils', 'eta-fraza-pochti-ne', 'Эта фраза почти не используется на поиске и в сетях, попробуйте изменить её.'));
                    params.phraseType == 'retargetings' && (helpText = iget2(
                        'i-utils',
                        'vy-vybrali-slishkom-uzkuyu',
                        'Вы выбрали слишком узкую целевую аудиторию или для неё очень высокая конкуренция. Расширьте или измените условие подбора аудитории.'
                    ));
                    params.phraseType == 'interests' && (helpText = iget2(
                        'i-utils',
                        'poprobuyte-dobavit-drugie-kategorii',
                        'Попробуйте добавить другие категории приложений. Выбранная вами категория слишком редкая или в ней очень высокая конкуренция.'
                    ));
                    params.phraseType == 'relevance_match' && (helpText = iget2(
                        'i-utils',
                        'vystavlennye-nastroyki-rabotayut-neeffektivno-100',
                        'Выставленные настройки работают неэффективно. Попробуйте поработать над текстом объявления, изменить ставку, настройки стратегии и т.д.'
                    ));
            }

            return helpText;
        }
    })

}());
