block('i-utils').match(function() {
    return this.utilsElem;
}).def()(function() {
    var data = this.data;

    // Mapping of unsafe HTML and invalid JavaScript line terminator chars to their
    // Unicode char counterparts which are safe to use in JavaScript strings.
    var ESCAPED_CHARS = {
        '<': '\\u003C',
        '>': '\\u003E',
        '/': '\\u002F',
        '\u2028': '\\u2028',
        '\u2029': '\\u2029'
    };
    var UNSAFE_CHARS_REGEXP = /[<>\/\u2028\u2029]/g;

    /**
     * Говорит, есть ли среди прав пользователя хотя бы одно из списка переданных
     * @param {...} rights
     * @returns {Boolean}
     */
    hasLoginRights = function( /*rights...*/ ) { // eslint-disable-line no-global-assign
        return Array.prototype.some.call(arguments, function(right) {
            return data.login_rights ? !!+data.login_rights[right] : false;
        });
    };

    /**
     * Говорит, включена ли для пользователя хотя бы одна фича из списка переданных
     * @param {...} features
     * @returns {Boolean}
     */
    hasEnabledFeatures = function( /*features...*/ ) { // eslint-disable-line no-global-assign
        return Array.prototype.some.call(arguments, function(feature_name) {
            return data.features_enabled_for_client ? !!+data.features_enabled_for_client[feature_name] : false;
        });
    };

    /**
     * Расширяет переданный хеш(как правило, параметры для u.getUrl/formatUrl) парой { uid_par.key: uid_par.value }
     * @param {Object} params
     * @returns {Object}
     */
    withUidPar = function(params) { // eslint-disable-line no-global-assign
        var key = (data.uid_par && data.uid_par.key) || 'ulogin';
        params[key] = (data.uid_par && data.uid_par.value) || data.uname || data.user_login;

        return params;
    };

    /**
     * Заменяет спецсимволы в строках, предназначающихся для вставки в тэг script, чтобы предотвратить XSS.
     * @param {String|undefined} string
     * @returns {String}
     */
    escapeJs = function(string) { // eslint-disable-line no-global-assign
        return !string ? '' : string.replace(UNSAFE_CHARS_REGEXP, function(unsafeChar) {
            return ESCAPED_CHARS[unsafeChar];
        });
    };

    /**
     * Безопасно сериализует объект в JSON, предназначенный для вставки в тэг script, чтобы предотвратить XSS.
     * @param {Object} obj
     * @returns {String}
     */
    safeStringify = function(obj) { // eslint-disable-line no-global-assign
        return escapeJs(JSON.stringify(obj)); // ignore stringify
    };

    return applyNext();
});
