u.register({

    /**
     * По нику роли получает её название
     * @param {String} roleAlias
     * @returns {String}
     */
    getRoleName: function(roleAlias) {
        var roleNames = {
            super: iget2('i-utils', 'super-polzovatel', 'супер-пользователь'),
            placer: iget2('i-utils', 'veshalshchik', 'вешальщик'),
            manager: iget2('i-utils', 'menedzher', 'менеджер'),
            agency: iget2('i-utils', 'agentstvo', 'агентство'),
            media: iget2('i-utils', 'mediaplaner', 'медиапланер'),
            support: iget2('i-utils', 'sapport', 'саппорт'),
            client: iget2('i-utils', 'klient', 'клиент'),
            superreader: iget2('i-utils', 'supersmotritel', 'суперсмотритель'),
            subclient: iget2('i-utils', 'subklient', 'субклиент'),
            supersubclient: iget2('i-utils', 'super-subklient', 'супер-субклиент'),
            teamleader: iget2('i-utils', 'timlider', 'тимлидер'),
            superteamleader: iget2('i-utils', 'nachalnik-otdela', 'начальник отдела')
        };

        return roleNames[roleAlias] || '';
    },

    /**
     * Получает название роли пользователя
     * используется только в шапке
     * @param {Object} rights data.login_rights
     * @returns {String}
     */
    getRoleNameForHead: function(rights) {
        if (!rights) return '';

        var rolesForHead = {
            super_control: iget2('i-utils', 'superpolzovatel', 'суперпользователь'),
            is_teamleader: iget2('i-utils', 'timlider', 'тимлидер'),
            is_superteamleader: iget2('i-utils', 'nachalnik-otdela', 'начальник отдела'),
            manager_control: iget2('i-utils', 'menedzher', 'менеджер'),
            placer_control: iget2('i-utils', 'veshalshchik', 'вешальщик'),
            agency_control: iget2('i-utils', 'agentstvo', 'агентство'),
            media_control: iget2('i-utils', 'mediaplaner', 'медиапланер'),
            support_control: iget2('i-utils', 'sapport', 'саппорт'),
            is_developer: iget2('i-utils', 'razrabotchik', 'разработчик'),
            superreader_control: iget2('i-utils', 'supersmotryashchiy', 'суперсмотрящий')
        };

        for (var role in rolesForHead) {
            if (rights[role]) return rolesForHead[role];
        }

        return '';
    }
});
