block('i-utils').match(function() {
    return this.utilsElem;
}).def()(function() {
    var data = this.data,
        form = data.FORM;

    u.register({
        getDates: function() {
            var dateFrom,
                dateTo;

            // По своему происхождению статистика делится на два типа. Старые табы showCampStat и новые showStat:
            //
            // в showCampStat период задается через d1 … y1 и d2 … y2
            // в showStat через date_from и date_to
            if (form.d1) {
                dateFrom = u.moment([
                    data.y1 || form.y1,
                    data.m1 || form.m1,
                    data.d1 || form.d1
                ].join('-'), 'YY-MM-DD');

                dateTo = u.moment([
                    data.y2 || form.y2,
                    data.m2 || form.m2,
                    data.d2 || form.d2
                ].join('-'), 'YY-MM-DD');
            } else if (form.date_from) {
                dateFrom = u.moment(data.date_from || form.date_from, 'YYYY-MM-DD');
                dateTo = u.moment(data.date_to || form.date_to, 'YYYY-MM-DD');
            }

            return {
                dateFrom: dateFrom,
                dateTo: dateTo
            };
        },
        getCommonStat: function() {
            var withNds = +data.FORM.with_nds || data.with_nds,
                common = {};

            common.with_nds = withNds ? 1 : 0;                              // флаг включенной опции НДС
            form.cid && (common.cid = form.cid);                            // ID кампаний по которым показывает статистика

            form.interface && (common.interface = form.interface);          // в каком интерфейсе(легком/профи) строить ссылку на страницу кампании
            form.target_type && (common.target_type = form.target_type);
            data.user_login && (common.ulogin = data.user_login);           // логин пользователя

            // Площадки all - всего, 0 - поиск, 1 - сети
            ['target_all', 'target_0', 'target_1'].forEach(function(name) {
                form[name] && (common[name] = 1);
            });

            return common;
        },
        getShowCampStat: function() {
            var group = form.group_by_date || form.group,
                common = u.getCommonStat(),
                showCampStat = u._.extend({
                    group: group
                }, common),
                date = u.getDates(),
                dateFrom = date.dateFrom,
                dateTo = date.dateTo;

            dateFrom && u._.extend(showCampStat, {
                y1: dateFrom.format('YY'),
                m1: dateFrom.format('MM'),
                d1: dateFrom.format('DD'),
                y2: dateTo.format('YY'),
                m2: dateTo.format('MM'),
                d2: dateTo.format('DD')
            });

            return showCampStat;
        },
        getShowStat: function() {
            var group = form.group_by_date || form.group,
                common = u.getCommonStat(),
                showStat = u._.extend({
                    group_by_date: group
                }, common),
                date = u.getDates(),
                dateFrom = date.dateFrom,
                dateTo = date.dateTo;

            dateFrom && u._.extend(showStat, {
                date_from: dateFrom.format('YYYY-MM-DD'),
                date_to: dateTo.format('YYYY-MM-DD')
            });

            return showStat;
        }
    });

    return applyNext();
});
