u.register({
    smartDesigner: {
        /**
         * Формирует ссылку на редактирование креативов
         * @param {Object} options
         * @param {Boolean} [options.isCompact]
         * @param {String} [options.retpathCmd]
         * @param {String} [options.groupId]
         * @param {Array} ids
         * @returns {String}
         */
        getEditUrl: function(options, ids) {
            var ulogin = u.consts('ulogin'),
                host = u.consts('SCRIPT_OBJECT').host,
                query = {
                    retpath: u.formatUrl({
                        protocol: 'https',
                        host: host,
                        query: {
                            cmd: options.retpathCmd || 'moderateCreatives',
                            ulogin: ulogin,
                            creative_id: ids
                        }
                    }),
                    client_login: ulogin,
                    compact: options.isCompact ? 1 : undefined
                };

            return u.formatUrl({
                protocol: 'https',
                host: host,
                path: options.groupId ?
                    '/smart-designer/' + options.groupId + '/edit/' :
                    '/smart-designer/creatives/' + ids.join(',') + '/edit',
                query: query
            })
        },

        /**
         *
         * Формирует ссылку на создание креатива
         * @param {Object} [options]
         * @param {Boolean} [options.isCompact]
         * @param {String} [options.retpathCmd]
         * @returns {String}
         */
        getAddUrl: function(options) {
            var host = u.consts('SCRIPT_OBJECT').host,
                ulogin = u.consts('ulogin');

            return u.formatUrl({
                protocol: 'https',
                host: u.consts('SCRIPT_OBJECT').host,
                path: '/smart-designer/add',
                query: {
                    retpath: options.retpathCmd && u.formatUrl({
                        protocol: 'https',
                        host: host,
                        query: {
                            cmd: options.retpathCmd,
                            ulogin: ulogin
                        }
                    }),
                    client_login: ulogin,
                    compact: options.isCompact ? 1 : undefined
                }
            })
        }
    }
});
