describe('i-utils__special-urls', function() {
    var sandbox,
        constStub;

    beforeEach(function() {
        sandbox = sinon.sandbox.create();
        constStub = sandbox.stub(u, 'consts');
    });

    afterEach(function() {
        sandbox.restore();
    });

    describe('getLegalUrl', function() {
        var path = '/adv_rules/';

        [
            [{ path: path, domain: 'ru', lang: 'ru' }, 'https://legal.yandex.ru/adv_rules/'],
            [{ path: path, domain: 'ru', lang: 'ua' }, 'https://legal.yandex.ua/adv_rules/'],
            [{ path: path, domain: 'ru', lang: 'en' }, 'https://legal.yandex.ru/adv_rules/'],

            [{ path: path, domain: 'com', lang: 'ru' }, 'https://legal.yandex.ru/adv_rules/'],
            [{ path: path, domain: 'com', lang: 'ua' }, 'https://legal.yandex.ru/adv_rules/'],
            [{ path: path, domain: 'com', lang: 'en' }, 'https://legal.yandex.ru/adv_rules/'],

            [{ path: path, domain: 'ua', lang: 'ru' }, 'https://legal.yandex.ua/adv_rules/'],
            [{ path: path, domain: 'ua', lang: 'ua' }, 'https://legal.yandex.ua/adv_rules/'],
            [{ path: path, domain: 'ua', lang: 'en' }, 'https://legal.yandex.ru/adv_rules/'],

            [{ path: path, domain: 'by', lang: 'ru' }, 'https://legal.yandex.ru/adv_rules/'],
            [{ path: path, domain: 'by', lang: 'ua' }, 'https://legal.yandex.ua/adv_rules/'],
            [{ path: path, domain: 'by', lang: 'en' }, 'https://legal.yandex.ru/adv_rules/'],

            [{ path: path, domain: 'kz', lang: 'ru' }, 'https://legal.yandex.ru/adv_rules/'],
            [{ path: path, domain: 'kz', lang: 'ua' }, 'https://legal.yandex.ua/adv_rules/'],
            [{ path: path, domain: 'kz', lang: 'en' }, 'https://legal.yandex.ru/adv_rules/'],

            [{ path: path, domain: 'com.tr', lang: 'en' }, 'https://legal.yandex.com.tr/adv_rules/'],
            [{ path: path, domain: 'com.tr', lang: 'tr' }, 'https://legal.yandex.com.tr/adv_rules/']
        ].forEach(function(item) {
            var expectedUrl = item[1],
                itemParams = item[0];

            it('Для пути ' + itemParams.path + ' на домене direct.yandex.' + itemParams.domain + ' с языком ' + itemParams.lang + ' ссылка должна выглядеть: ' + expectedUrl, function() {
                constStub.withArgs('lang').returns(itemParams.lang);
                constStub.withArgs('tld').returns(itemParams.domain);

                expect(u.getLegalUrl(itemParams.path)).to.be.eql(expectedUrl);
            });
        });
    });
});
