(function() {
    var legalDomainAndLangToDomain = {
            ru: {
                ru: 'ru',
                en: 'ru',
                ua: 'ua'
            },
            by: {
                ru: 'ru',
                en: 'ru',
                ua: 'ua'
            },
            kz: {
                ru: 'ru',
                en: 'ru',
                ua: 'ua'
            },
            com: {
                ru: 'ru',
                en: 'ru',
                ua: 'ru'
            },
            ua: {
                ru: 'ua',
                en: 'ru',
                ua: 'ua'
            },
            'com.tr': {
                en: 'com.tr',
                tr: 'com.tr'
            }
        },
        /**
         * Возвращает ссылку до legal для нужного path в зависимости от домена и языка
         * (На самом деле возвращает ссылку на tune.yandex.* с выставлением нужного языка и retpath до нужной страницы legal)
         * @param {String} path
         * @returns {String}
         */
        getLegalUrl = function(path) {
            var lang = u.consts('lang'),
                domain = u.consts('tld'),
                legalDomain = legalDomainAndLangToDomain[domain][lang];

            return u.formatUrl({
                protocol: 'https',
                host: 'legal.yandex.' + legalDomain,
                path: path
            });
        },
        getEditGroupInNewInterfaceUrl = function(isNew, query) {
            var resultQuery = u._.extend({
                from_old_interface: '1',
                'campaigns-ids': query.cid,
                'groups-ids': query.adgroupId
            }, query, {
                cid: undefined,
                adgroupId: undefined
            });

            if (isNew) {
                resultQuery['is-new-empty-group'] = '1';
                resultQuery['is-new'] = '1';
            }

            return u.formatUrl({
                path: '/dna/groups-edit',
                query: resultQuery
            });
        },
        getEditBannersInNewInterfaceUrl = function(isNew, query) {
            var resultQuery = u._.extend({
                from_old_interface: 1,
                'campaigns-ids': query.cid,
                'banners-ids': query.bids.join(','),
                'groups-ids': query.adgroupId
            }, query, {
                cid: undefined,
                adgroupId: undefined,
                bids: undefined
            });

            if (isNew) {
                resultQuery['is-new'] = '1';
            }

            return u.formatUrl({
                path: '/dna/banners-edit',
                query: resultQuery
            });
        };

    u.register({
        getLegalUrl: getLegalUrl,
        getEditGroupInNewInterfaceUrl: getEditGroupInNewInterfaceUrl,
        getEditBannersInNewInterfaceUrl: getEditBannersInNewInterfaceUrl
    });
}());
